/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.sitediversity.sitediversity;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.sitediversity.sitediversity.groups.Group;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of groups.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultGroups extends InnerModelObject implements Groups {
    protected List<Group> group;

    @Override
    public List<Group> group() {
        return group;
    }

    @Override
    public void group(List<Group> group) {
        this.group = group;
    }

    @Override
    public void addToGroup(Group addTo) {
        if (group == null) {
            group = new ArrayList<>();
        }
        group.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(group);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultGroups) {
            DefaultGroups other = (DefaultGroups) obj;
            return
                Objects.equals(group, other.group);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("group=" + group)
            .toString();
    }


    /**
     * Creates an instance of defaultGroups.
     */
    public DefaultGroups() {
    }

}