/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.siterouting.routingprotocols.routingprotocol;

import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.siterouting.routingprotocols.routingprotocol.yangautoprefixstatic.CascadedLanPrefixes;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of yangAutoPrefixStatic.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultYangAutoPrefixStatic extends InnerModelObject implements YangAutoPrefixStatic {
    protected CascadedLanPrefixes cascadedLanPrefixes;

    @Override
    public CascadedLanPrefixes cascadedLanPrefixes() {
        return cascadedLanPrefixes;
    }

    @Override
    public void cascadedLanPrefixes(CascadedLanPrefixes cascadedLanPrefixes) {
        this.cascadedLanPrefixes = cascadedLanPrefixes;
    }

    @Override
    public int hashCode() {
        return Objects.hash(cascadedLanPrefixes);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultYangAutoPrefixStatic) {
            DefaultYangAutoPrefixStatic other = (DefaultYangAutoPrefixStatic) obj;
            return
                Objects.equals(cascadedLanPrefixes, other.cascadedLanPrefixes);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("cascadedLanPrefixes=" + cascadedLanPrefixes)
            .toString();
    }


    /**
     * Creates an instance of defaultYangAutoPrefixStatic.
     */
    public DefaultYangAutoPrefixStatic() {
    }

}