/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.siteservicemulticast.multicast;

/**
 * Represents ENUM data of protocolTypeEnum.
 */
public enum ProtocolTypeEnum {

    /**
     * Represents host.
     */
    HOST(0, "host"),

    /**
     * Represents router.
     */
    ROUTER(1, "router"),

    /**
     * Represents both.
     */
    BOTH(2, "both");

    private int protocolTypeEnum;
    private String schemaName;

    /**
     * Creates an instance of protocolTypeEnum.
     *
     * @param protocolTypeEnum value of protocolTypeEnum
     */
     ProtocolTypeEnum(int protocolTypeEnum, String schemaName) {
        this.protocolTypeEnum = protocolTypeEnum;
        this.schemaName = schemaName;
    }

    /**
     * Returns the object of protocolTypeEnum for.
     *
     * @param value value of protocolTypeEnum for
     * @return protocolTypeEnum for
     */
    public static ProtocolTypeEnum of(int value) {
        switch (value) {
            case 0:
                return ProtocolTypeEnum.HOST;
            case 1:
                return ProtocolTypeEnum.ROUTER;
            case 2:
                return ProtocolTypeEnum.BOTH;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the object of protocolTypeEnum for.
     *
     * @param value value of protocolTypeEnum for
     * @return protocolTypeEnum for
     */
    public static ProtocolTypeEnum of(String value) {
        switch (value) {
            case "host":
                return ProtocolTypeEnum.HOST;
            case "router":
                return ProtocolTypeEnum.ROUTER;
            case "both":
                return ProtocolTypeEnum.BOTH;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the attribute protocolTypeEnum.
     *
     * @return protocolTypeEnum value of protocolTypeEnum
     */
    public int protocolTypeEnum() {
        return protocolTypeEnum;
    }


    @Override
    public String toString() {
        return schemaName;
    }
}
