/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.vpnservicecloudaccess.cloudaccesses;

import java.lang.String;
import org.onosproject.yang.model.KeyInfo;
import java.util.Objects;

/**
 * Represents the implementation of cloudAccess.
 */
public class CloudAccessKeys implements KeyInfo<DefaultCloudAccess> {
    protected String cloudIdentifier;
    /**
     * Returns the attribute cloudIdentifier.
     *
     * @return cloudIdentifier value of cloudIdentifier
     */
    public String cloudIdentifier() {
        return cloudIdentifier;
    }

    /**
     * Sets the value to attribute cloudIdentifier.
     *
     * @param cloudIdentifier value of cloudIdentifier
     */
    public void cloudIdentifier(String cloudIdentifier) {
        this.cloudIdentifier = cloudIdentifier;
    }


    @Override
    public int hashCode() {
        return Objects.hash(cloudIdentifier);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof CloudAccessKeys) {
            CloudAccessKeys other = (CloudAccessKeys) obj;
            return
                Objects.equals(cloudIdentifier, other.cloudIdentifier);
        }
        return false;
    }
}