/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.vpnservicemulticast;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.vpnservicemulticast.multicast.CustomerTreeFlavors;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.vpnservicemulticast.multicast.Rp;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of multicast.
 */
public interface Multicast extends Augmentable  {

    /**
     * Identify the leaf of Multicast.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents enabled.
         */
        ENABLED(1);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute enabled.
     *
     * @return enabled value of enabled
     */
    boolean enabled();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute customerTreeFlavors.
     *
     * @return customerTreeFlavors value of customerTreeFlavors
     */
    CustomerTreeFlavors customerTreeFlavors();

    /**
     * Returns the attribute rp.
     *
     * @return rp value of rp
     */
    Rp rp();

    /**
     * Sets the attribute enabled.
     *
     * @param enabled value of enabled
     */
    void enabled(boolean enabled);

    /**
     * Sets the attribute customerTreeFlavors.
     *
     * @param customerTreeFlavors value of customerTreeFlavors
     */
    void customerTreeFlavors(CustomerTreeFlavors customerTreeFlavors);

    /**
     * Sets the attribute rp.
     *
     * @param rp value of rp
     */
    void rp(Rp rp);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}