/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.vpnservicemulticast.multicast.rp.rpgroupmappings;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.vpnservicemulticast.multicast.rp.rpgroupmappings.rpgroupmapping.Groups;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.vpnservicemulticast.multicast.rp.rpgroupmappings.rpgroupmapping.ProviderManaged;
import org.onosproject.yang.gen.v1.yrtietfinettypes.rev20130715.yrtietfinettypes.IpAddress;
import org.onosproject.yang.model.InnerModelObject;
import org.onosproject.yang.model.MultiInstanceObject;

/**
 * Represents the implementation of rpGroupMapping.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultRpGroupMapping extends InnerModelObject 
        implements RpGroupMapping, MultiInstanceObject<RpGroupMappingKeys> {
    protected int id;
    protected IpAddress rpAddress;
    protected BitSet valueLeafFlags = new BitSet();
    protected ProviderManaged providerManaged;
    protected Groups groups;

    @Override
    public int id() {
        return id;
    }

    @Override
    public IpAddress rpAddress() {
        return rpAddress;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public ProviderManaged providerManaged() {
        return providerManaged;
    }

    @Override
    public Groups groups() {
        return groups;
    }

    @Override
    public void id(int id) {
        valueLeafFlags.set(LeafIdentifier.ID.getLeafIndex());
        this.id = id;
    }

    @Override
    public void rpAddress(IpAddress rpAddress) {
        valueLeafFlags.set(LeafIdentifier.RPADDRESS.getLeafIndex());
        this.rpAddress = rpAddress;
    }

    @Override
    public void providerManaged(ProviderManaged providerManaged) {
        this.providerManaged = providerManaged;
    }

    @Override
    public void groups(Groups groups) {
        this.groups = groups;
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, rpAddress, valueLeafFlags, providerManaged, groups);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultRpGroupMapping) {
            DefaultRpGroupMapping other = (DefaultRpGroupMapping) obj;
            return
                Objects.equals(id, other.id) &&
                Objects.equals(rpAddress, other.rpAddress) &&
                Objects.equals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.equals(providerManaged, other.providerManaged) &&
                Objects.equals(groups, other.groups);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("id=" + id)
            .add("rpAddress=" + rpAddress)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("providerManaged=" + providerManaged)
            .add("groups=" + groups)
            .toString();
    }


    /**
     * Creates an instance of defaultRpGroupMapping.
     */
    public DefaultRpGroupMapping() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}