/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.l3vpnsvcext.rev20160730.l3vpnsvcext;

import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.TransportConstraint;

/**
 * Represents the implementation of tcDemandedTunnel.
 */
public abstract class TcDemandedTunnel extends TransportConstraint {

    /**
     * Returns the attribute tc-demanded-tunnel.
     *
     * @return tc-demanded-tunnel value of tc-demanded-tunnel
     */
    public static String tcDemandedTunnelToString() {
        return "tc-demanded-tunnel";
    }

    /**
     * Returns the object of tcDemandedTunnel fromString input String tcDemandedTunnel.
     *
     * @param valInString value of input String
     * @return tcDemandedTunnel
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("tc-demanded-tunnel")) {
            return TcDemandedTunnel.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}