/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.l3vpnsvcext.rev20160730.l3vpnsvcext.bearerattachmentgrouping;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.yrtietfinettypes.rev20130715.yrtietfinettypes.Ipv4Address;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of bearerAttachment.
 */
public interface BearerAttachment extends Augmentable  {

    /**
     * Identify the leaf of BearerAttachment.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents peName.
         */
        PENAME(1),
        /**
         * Represents peMgmtIp.
         */
        PEMGMTIP(2);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute peName.
     *
     * @return peName value of peName
     */
    String peName();

    /**
     * Returns the attribute peMgmtIp.
     *
     * @return peMgmtIp value of peMgmtIp
     */
    Ipv4Address peMgmtIp();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Sets the attribute peName.
     *
     * @param peName value of peName
     */
    void peName(String peName);

    /**
     * Sets the attribute peMgmtIp.
     *
     * @param peMgmtIp value of peMgmtIp
     */
    void peMgmtIp(Ipv4Address peMgmtIp);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}