/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.l3vpnsvcext.rev20160730.l3vpnsvcext.bfdgrouping.holdtime;

import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.l3vpnsvcext.rev20160730.l3vpnsvcext.bfdgrouping.Holdtime;
import org.onosproject.yang.gen.v1.l3vpnsvcext.rev20160730.l3vpnsvcext.bfdgrouping.holdtime.dynamic.DynamicValue;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of dynamic.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultDynamic extends InnerModelObject implements Dynamic {
    protected DynamicValue dynamicValue;

    @Override
    public DynamicValue dynamicValue() {
        return dynamicValue;
    }

    @Override
    public void dynamicValue(DynamicValue dynamicValue) {
        this.dynamicValue = dynamicValue;
    }

    @Override
    public int hashCode() {
        return Objects.hash(dynamicValue);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultDynamic) {
            DefaultDynamic other = (DefaultDynamic) obj;
            return
                Objects.equals(dynamicValue, other.dynamicValue);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("dynamicValue=" + dynamicValue)
            .toString();
    }


    /**
     * Creates an instance of defaultDynamic.
     */
    public DefaultDynamic() {
    }

}