/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.l3vpnsvcext.rev20160730.l3vpnsvcext.bgpprofile;

import java.util.BitSet;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of password.
 */
public interface Password extends Augmentable  {

    /**
     * Identify the leaf of Password.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents passwordEnabled.
         */
        PASSWORDENABLED(1),
        /**
         * Represents passwordValue.
         */
        PASSWORDVALUE(2);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute passwordEnabled.
     *
     * @return passwordEnabled value of passwordEnabled
     */
    boolean passwordEnabled();

    /**
     * Returns the attribute passwordValue.
     *
     * @return passwordValue value of passwordValue
     */
    String passwordValue();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Sets the attribute passwordEnabled.
     *
     * @param passwordEnabled value of passwordEnabled
     */
    void passwordEnabled(boolean passwordEnabled);

    /**
     * Sets the attribute passwordValue.
     *
     * @param passwordValue value of passwordValue
     */
    void passwordValue(String passwordValue);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}