/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.l3vpnsvcext.rev20160730.l3vpnsvcext.classprofile;

import java.util.BitSet;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of qosClass.
 */
public interface QosClass extends Augmentable  {

    /**
     * Identify the leaf of QosClass.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents classId.
         */
        CLASSID(1),
        /**
         * Represents rateLimit.
         */
        RATELIMIT(2),
        /**
         * Represents priorityLevel.
         */
        PRIORITYLEVEL(3),
        /**
         * Represents guaranteedBwPercent.
         */
        GUARANTEEDBWPERCENT(4);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute classId.
     *
     * @return classId value of classId
     */
    String classId();

    /**
     * Returns the attribute rateLimit.
     *
     * @return rateLimit value of rateLimit
     */
    short rateLimit();

    /**
     * Returns the attribute priorityLevel.
     *
     * @return priorityLevel value of priorityLevel
     */
    short priorityLevel();

    /**
     * Returns the attribute guaranteedBwPercent.
     *
     * @return guaranteedBwPercent value of guaranteedBwPercent
     */
    short guaranteedBwPercent();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Sets the attribute classId.
     *
     * @param classId value of classId
     */
    void classId(String classId);

    /**
     * Sets the attribute rateLimit.
     *
     * @param rateLimit value of rateLimit
     */
    void rateLimit(short rateLimit);

    /**
     * Sets the attribute priorityLevel.
     *
     * @param priorityLevel value of priorityLevel
     */
    void priorityLevel(short priorityLevel);

    /**
     * Sets the attribute guaranteedBwPercent.
     *
     * @param guaranteedBwPercent value of guaranteedBwPercent
     */
    void guaranteedBwPercent(short guaranteedBwPercent);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}