/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.l3vpnsvcext.rev20160730.l3vpnsvcext.extendedcommunity.extendedcommunity;

import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.l3vpnsvcext.rev20160730.l3vpnsvcext.extendedcommunity.ExtendedCommunity;
import org.onosproject.yang.gen.v1.l3vpnsvcext.rev20160730.l3vpnsvcext.extendedcommunity.extendedcommunity.routetargetextendedcommunitycase.RouteTargetExtendedCommunity;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of routeTargetExtendedCommunityCase.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultRouteTargetExtendedCommunityCase extends InnerModelObject implements RouteTargetExtendedCommunityCase {
    protected RouteTargetExtendedCommunity routeTargetExtendedCommunity;

    @Override
    public RouteTargetExtendedCommunity routeTargetExtendedCommunity() {
        return routeTargetExtendedCommunity;
    }

    @Override
    public void routeTargetExtendedCommunity(RouteTargetExtendedCommunity routeTargetExtendedCommunity) {
        this.routeTargetExtendedCommunity = routeTargetExtendedCommunity;
    }

    @Override
    public int hashCode() {
        return Objects.hash(routeTargetExtendedCommunity);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultRouteTargetExtendedCommunityCase) {
            DefaultRouteTargetExtendedCommunityCase other = (DefaultRouteTargetExtendedCommunityCase) obj;
            return
                Objects.equals(routeTargetExtendedCommunity, other.routeTargetExtendedCommunity);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("routeTargetExtendedCommunity=" + routeTargetExtendedCommunity)
            .toString();
    }


    /**
     * Creates an instance of defaultRouteTargetExtendedCommunityCase.
     */
    public DefaultRouteTargetExtendedCommunityCase() {
    }

}