/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.l3vpnsvcext.rev20160730.l3vpnsvcext.l3vpnsvc.sites.site.sitenetworkaccesses.sitenetworkaccess.routingprotocols.routingprotocol.bgp;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.l3vpnsvcext.rev20160730.l3vpnsvcext.bgpprofile.Bfd;
import org.onosproject.yang.gen.v1.l3vpnsvcext.rev20160730.l3vpnsvcext.bgpprofile.BgpTimer;
import org.onosproject.yang.gen.v1.l3vpnsvcext.rev20160730.l3vpnsvcext.bgpprofile.Password;
import org.onosproject.yang.gen.v1.l3vpnsvcext.rev20160730.l3vpnsvcext.bgpprofile.Soo;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of augmentedL3VpnBgp.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultAugmentedL3VpnBgp extends InnerModelObject implements AugmentedL3VpnBgp {
    protected boolean asOverride;
    protected BitSet valueLeafFlags = new BitSet();
    protected Soo soo;
    protected Password password;
    protected BgpTimer bgpTimer;
    protected Bfd bfd;

    @Override
    public boolean asOverride() {
        return asOverride;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public Soo soo() {
        return soo;
    }

    @Override
    public Password password() {
        return password;
    }

    @Override
    public BgpTimer bgpTimer() {
        return bgpTimer;
    }

    @Override
    public Bfd bfd() {
        return bfd;
    }

    @Override
    public void asOverride(boolean asOverride) {
        valueLeafFlags.set(LeafIdentifier.ASOVERRIDE.getLeafIndex());
        this.asOverride = asOverride;
    }

    @Override
    public void soo(Soo soo) {
        this.soo = soo;
    }

    @Override
    public void password(Password password) {
        this.password = password;
    }

    @Override
    public void bgpTimer(BgpTimer bgpTimer) {
        this.bgpTimer = bgpTimer;
    }

    @Override
    public void bfd(Bfd bfd) {
        this.bfd = bfd;
    }

    @Override
    public int hashCode() {
        return Objects.hash(asOverride, valueLeafFlags, soo, password, bgpTimer, bfd);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultAugmentedL3VpnBgp) {
            DefaultAugmentedL3VpnBgp other = (DefaultAugmentedL3VpnBgp) obj;
            return
                Objects.equals(asOverride, other.asOverride) &&
                Objects.equals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.equals(soo, other.soo) &&
                Objects.equals(password, other.password) &&
                Objects.equals(bgpTimer, other.bgpTimer) &&
                Objects.equals(bfd, other.bfd);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("asOverride=" + asOverride)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("soo=" + soo)
            .add("password=" + password)
            .add("bgpTimer=" + bgpTimer)
            .add("bfd=" + bfd)
            .toString();
    }


    /**
     * Creates an instance of defaultAugmentedL3VpnBgp.
     */
    public DefaultAugmentedL3VpnBgp() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}