/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.leafreftest.rev20160524;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.leafreftest.rev20160524.leafreftest.Cont1;
import org.onosproject.yang.gen.v1.leafreftest.rev20160524.leafreftest.Food;
import org.onosproject.yang.gen.v1.leafreftest.rev20160524.leafreftest.LeafrefList;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of leafreftest.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class LeafreftestOpParam extends InnerModelObject implements Leafreftest {
    protected String middlename;
    protected String name;
    protected BitSet valueLeafFlags = new BitSet();
    protected List<LeafrefList> leafrefList;
    protected Cont1 cont1;
    protected Food food;

    @Override
    public String middlename() {
        return middlename;
    }

    @Override
    public String name() {
        return name;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public List<LeafrefList> leafrefList() {
        return leafrefList;
    }

    @Override
    public Cont1 cont1() {
        return cont1;
    }

    @Override
    public Food food() {
        return food;
    }

    @Override
    public void middlename(String middlename) {
        valueLeafFlags.set(LeafIdentifier.MIDDLENAME.getLeafIndex());
        this.middlename = middlename;
    }

    @Override
    public void name(String name) {
        valueLeafFlags.set(LeafIdentifier.NAME.getLeafIndex());
        this.name = name;
    }

    @Override
    public void leafrefList(List<LeafrefList> leafrefList) {
        this.leafrefList = leafrefList;
    }

    @Override
    public void cont1(Cont1 cont1) {
        this.cont1 = cont1;
    }

    @Override
    public void food(Food food) {
        this.food = food;
    }

    @Override
    public void addToLeafrefList(LeafrefList addTo) {
        if (leafrefList == null) {
            leafrefList = new ArrayList<>();
        }
        leafrefList.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(middlename, name, valueLeafFlags, leafrefList, cont1, food);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LeafreftestOpParam) {
            LeafreftestOpParam other = (LeafreftestOpParam) obj;
            return
                Objects.equals(middlename, other.middlename) &&
                Objects.equals(name, other.name) &&
                Objects.equals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.equals(leafrefList, other.leafrefList) &&
                Objects.equals(cont1, other.cont1) &&
                Objects.equals(food, other.food);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("middlename=" + middlename)
            .add("name=" + name)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("leafrefList=" + leafrefList)
            .add("cont1=" + cont1)
            .add("food=" + food)
            .toString();
    }

    /**
     * Creates an instance of leafreftestOpParam.
     */
    public LeafreftestOpParam() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }


    @Override
    public void addAugmentation(InnerModelObject obj) {
    }

    @Override
    public void removeAugmentation(InnerModelObject obj) {
    }

    @Override
    public Map<Class<? extends InnerModelObject>, InnerModelObject> augmentations() {

        return null;
    }

    @Override
    public <T extends InnerModelObject> T augmentation(Class<T> c) {

        return null;
    }
}