/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.logisticsmanager.rev20160524;

import java.util.BitSet;
import java.util.List;
import org.onosproject.yang.gen.v1.logisticsmanager.rev20160524.logisticsmanager.MaterialSupervisor;
import org.onosproject.yang.gen.v1.logisticsmanager.rev20160524.logisticsmanager.PurchasingSupervisor;

/**
 * Abstraction of an entity which represents the functionality of logisticsManager.
 */
public interface LogisticsManager {

    /**
     * Identify the leaf of LogisticsManager.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents customsSupervisor.
         */
        CUSTOMSSUPERVISOR(1),
        /**
         * Represents merchandiserSupervisor.
         */
        MERCHANDISERSUPERVISOR(2),
        /**
         * Represents tradingSupervisor.
         */
        TRADINGSUPERVISOR(3),
        /**
         * Represents warehouseSupervisor.
         */
        WAREHOUSESUPERVISOR(4),
        /**
         * Represents employeeId.
         */
        EMPLOYEEID(5);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute customsSupervisor.
     *
     * @return customsSupervisor value of customsSupervisor
     */
    String customsSupervisor();

    /**
     * Returns the attribute merchandiserSupervisor.
     *
     * @return merchandiserSupervisor value of merchandiserSupervisor
     */
    String merchandiserSupervisor();

    /**
     * Returns the attribute tradingSupervisor.
     *
     * @return tradingSupervisor value of tradingSupervisor
     */
    String tradingSupervisor();

    /**
     * Returns the attribute warehouseSupervisor.
     *
     * @return warehouseSupervisor list of warehouseSupervisor
     */
    List<String> warehouseSupervisor();

    /**
     * Returns the attribute employeeId.
     *
     * @return employeeId list of employeeId
     */
    List<String> employeeId();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute materialSupervisor.
     *
     * @return materialSupervisor list of materialSupervisor
     */
    List<MaterialSupervisor> materialSupervisor();

    /**
     * Returns the attribute purchasingSupervisor.
     *
     * @return purchasingSupervisor value of purchasingSupervisor
     */
    PurchasingSupervisor purchasingSupervisor();

    /**
     * Sets the attribute customsSupervisor.
     *
     * @param customsSupervisor value of customsSupervisor
     */
    void customsSupervisor(String customsSupervisor);

    /**
     * Sets the attribute merchandiserSupervisor.
     *
     * @param merchandiserSupervisor value of merchandiserSupervisor
     */
    void merchandiserSupervisor(String merchandiserSupervisor);

    /**
     * Sets the attribute tradingSupervisor.
     *
     * @param tradingSupervisor value of tradingSupervisor
     */
    void tradingSupervisor(String tradingSupervisor);

    /**
     * Sets the attribute warehouseSupervisor.
     *
     * @param warehouseSupervisor list of warehouseSupervisor
     */
    void warehouseSupervisor(List<String> warehouseSupervisor);

    /**
     * Sets the attribute employeeId.
     *
     * @param employeeId list of employeeId
     */
    void employeeId(List<String> employeeId);

    /**
     * Sets the attribute materialSupervisor.
     *
     * @param materialSupervisor list of materialSupervisor
     */
    void materialSupervisor(List<MaterialSupervisor> materialSupervisor);

    /**
     * Sets the attribute purchasingSupervisor.
     *
     * @param purchasingSupervisor value of purchasingSupervisor
     */
    void purchasingSupervisor(PurchasingSupervisor purchasingSupervisor);

    /**
     * Adds to the list of warehouseSupervisor.
     *
     * @param addTo value of warehouseSupervisor
     */
    void addToWarehouseSupervisor(String addTo);

    /**
     * Adds to the list of employeeId.
     *
     * @param addTo value of employeeId
     */
    void addToEmployeeId(String addTo);

    /**
     * Adds to the list of materialSupervisor.
     *
     * @param addTo value of materialSupervisor
     */
    void addToMaterialSupervisor(MaterialSupervisor addTo);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}