/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.modeldatatoresourcedata.rev20160826.modeldatatoresourcedata;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.modeldatatoresourcedata.rev20160826.modeldatatoresourcedata.bitstypedef.Bits;
import java.util.Objects;

/**
 * Represents the implementation of bitsTypedef.
 */
public final class BitsTypedef {

    private BitSet bits;

    /**
     * Creates an instance of bitsTypedef.
     */
    private BitsTypedef() {
    }

    /**
     * Creates an instance of bits.
     *
     * @param bits value of bits
     */
    public BitsTypedef(BitSet bits) {
        this.bits = bits;
    }

    /**
     * Returns the object of bitsTypedef for type bits.
     *
     * @param value value of bitsTypedef for type bits
     * @return bitsTypedef for type bits
     */
    public static BitsTypedef of(BitSet value) {
        return new BitsTypedef(value);
    }

    /**
     * Returns the attribute bits.
     *
     * @return bits value of bits
     */
    public BitSet bits() {
        return bits;
    }
    /**
     * Sets the attribute bits.
     *
     * @param bits value of bits
     */
    public void bits(BitSet bits) {
        this.bits = bits;
    }

    @Override
    public int hashCode() {
        return Objects.hash(bits);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BitsTypedef) {
            BitsTypedef other = (BitsTypedef) obj;
            return
                Objects.equals(bits, other.bits);
        }
        return false;
    }

    @Override
    public String toString() {
        return Bits.toString(bits);
    }
    /**
     * Returns the object of bitsTypedef fromString input String bitsTypedef.
     *
     * @param valInString value of input String
     * @return bitsTypedef
     */
    public static BitsTypedef fromString(String valInString) {
        try {
            BitSet tmpVal = Bits.fromString(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
