/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.modeldatatoresourcedata.rev20160826.modeldatatoresourcedata;

import java.util.List;
import org.onosproject.yang.gen.v1.modeldatatoresourcedata.rev20160826.modeldatatoresourcedata.firstlevel.ContainerChoice;
import org.onosproject.yang.gen.v1.modeldatatoresourcedata.rev20160826.modeldatatoresourcedata.firstlevel.ContainerGrouping;
import org.onosproject.yang.gen.v1.modeldatatoresourcedata.rev20160826.modeldatatoresourcedata.firstlevel.ContainerLeaf;
import org.onosproject.yang.gen.v1.modeldatatoresourcedata.rev20160826.modeldatatoresourcedata.firstlevel.ContainerLeafList;
import org.onosproject.yang.gen.v1.modeldatatoresourcedata.rev20160826.modeldatatoresourcedata.firstlevel.ContainerList;
import org.onosproject.yang.gen.v1.modeldatatoresourcedata.rev20160826.modeldatatoresourcedata.firstlevel.ListInList;
import org.onosproject.yang.gen.v1.modeldatatoresourcedata.rev20160826.modeldatatoresourcedata.firstlevel.OnlyContainer;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of firstLevel.
 */
public interface FirstLevel extends Augmentable  {

    /**
     * Returns the attribute onlyContainer.
     *
     * @return onlyContainer value of onlyContainer
     */
    OnlyContainer onlyContainer();

    /**
     * Returns the attribute containerLeaf.
     *
     * @return containerLeaf value of containerLeaf
     */
    ContainerLeaf containerLeaf();

    /**
     * Returns the attribute containerLeafList.
     *
     * @return containerLeafList value of containerLeafList
     */
    ContainerLeafList containerLeafList();

    /**
     * Returns the attribute containerList.
     *
     * @return containerList value of containerList
     */
    ContainerList containerList();

    /**
     * Returns the attribute containerChoice.
     *
     * @return containerChoice value of containerChoice
     */
    ContainerChoice containerChoice();

    /**
     * Returns the attribute containerGrouping.
     *
     * @return containerGrouping value of containerGrouping
     */
    ContainerGrouping containerGrouping();

    /**
     * Returns the attribute listInList.
     *
     * @return listInList list of listInList
     */
    List<ListInList> listInList();

    /**
     * Sets the attribute onlyContainer.
     *
     * @param onlyContainer value of onlyContainer
     */
    void onlyContainer(OnlyContainer onlyContainer);

    /**
     * Sets the attribute containerLeaf.
     *
     * @param containerLeaf value of containerLeaf
     */
    void containerLeaf(ContainerLeaf containerLeaf);

    /**
     * Sets the attribute containerLeafList.
     *
     * @param containerLeafList value of containerLeafList
     */
    void containerLeafList(ContainerLeafList containerLeafList);

    /**
     * Sets the attribute containerList.
     *
     * @param containerList value of containerList
     */
    void containerList(ContainerList containerList);

    /**
     * Sets the attribute containerChoice.
     *
     * @param containerChoice value of containerChoice
     */
    void containerChoice(ContainerChoice containerChoice);

    /**
     * Sets the attribute containerGrouping.
     *
     * @param containerGrouping value of containerGrouping
     */
    void containerGrouping(ContainerGrouping containerGrouping);

    /**
     * Sets the attribute listInList.
     *
     * @param listInList list of listInList
     */
    void listInList(List<ListInList> listInList);

    /**
     * Adds to the list of listInList.
     *
     * @param addTo value of listInList
     */
    void addToListInList(ListInList addTo);

}