/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.modulelistandkey.rev20160826;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.modulelistandkey.rev20160826.modulelistandkey.Bitdef;
import org.onosproject.yang.gen.v1.modulelistandkey.rev20160826.modulelistandkey.Id;
import org.onosproject.yang.gen.v1.modulelistandkey.rev20160826.modulelistandkey.Ll1Union;
import org.onosproject.yang.gen.v1.modulelistandkey.rev20160826.modulelistandkey.Ll6Enum;
import org.onosproject.yang.gen.v1.modulelistandkey.rev20160826.modulelistandkey.ModKey;
import org.onosproject.yang.gen.v1.modulelistandkey.rev20160826.modulelistandkey.Tdef1;
import org.onosproject.yang.gen.v1.modulelistandkey.rev20160826.modulelistandkey.Type;
import org.onosproject.yang.gen.v1.modulelistandkey.rev20160826.modulelistandkey.Val;
import org.onosproject.yang.gen.v1.modulelistandkey.rev20160826.modulelistandkey.YangAutoPrefixInt;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of moduleListAndKey.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class ModuleListAndKeyOpParam extends InnerModelObject implements ModuleListAndKey {
    protected List<Class<? extends YangAutoPrefixInt>> tri;
    protected List<Ll1Union> ll1;
    protected List<Class<? extends YangAutoPrefixInt>> ll2;
    protected List<Tdef1> ll3;
    protected List<Class<? extends YangAutoPrefixInt>> ll4;
    protected List<String> ll5;
    protected List<Ll6Enum> ll6;
    protected List<Bitdef> ll7;
    protected List<byte[]> ll8;
    protected List<Id> ll9;
    protected BitSet valueLeafFlags = new BitSet();
    protected List<ModKey> modKey;
    protected List<Type> type;
    protected Val val;

    @Override
    public List<Class<? extends YangAutoPrefixInt>> tri() {
        return tri;
    }

    @Override
    public List<Ll1Union> ll1() {
        return ll1;
    }

    @Override
    public List<Class<? extends YangAutoPrefixInt>> ll2() {
        return ll2;
    }

    @Override
    public List<Tdef1> ll3() {
        return ll3;
    }

    @Override
    public List<Class<? extends YangAutoPrefixInt>> ll4() {
        return ll4;
    }

    @Override
    public List<String> ll5() {
        return ll5;
    }

    @Override
    public List<Ll6Enum> ll6() {
        return ll6;
    }

    @Override
    public List<Bitdef> ll7() {
        return ll7;
    }

    @Override
    public List<byte[]> ll8() {
        return ll8;
    }

    @Override
    public List<Id> ll9() {
        return ll9;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public List<ModKey> modKey() {
        return modKey;
    }

    @Override
    public List<Type> type() {
        return type;
    }

    @Override
    public Val val() {
        return val;
    }

    @Override
    public void tri(List<Class<? extends YangAutoPrefixInt>> tri) {
        valueLeafFlags.set(LeafIdentifier.TRI.getLeafIndex());
        this.tri = tri;
    }

    @Override
    public void ll1(List<Ll1Union> ll1) {
        valueLeafFlags.set(LeafIdentifier.LL1.getLeafIndex());
        this.ll1 = ll1;
    }

    @Override
    public void ll2(List<Class<? extends YangAutoPrefixInt>> ll2) {
        valueLeafFlags.set(LeafIdentifier.LL2.getLeafIndex());
        this.ll2 = ll2;
    }

    @Override
    public void ll3(List<Tdef1> ll3) {
        valueLeafFlags.set(LeafIdentifier.LL3.getLeafIndex());
        this.ll3 = ll3;
    }

    @Override
    public void ll4(List<Class<? extends YangAutoPrefixInt>> ll4) {
        valueLeafFlags.set(LeafIdentifier.LL4.getLeafIndex());
        this.ll4 = ll4;
    }

    @Override
    public void ll5(List<String> ll5) {
        valueLeafFlags.set(LeafIdentifier.LL5.getLeafIndex());
        this.ll5 = ll5;
    }

    @Override
    public void ll6(List<Ll6Enum> ll6) {
        valueLeafFlags.set(LeafIdentifier.LL6.getLeafIndex());
        this.ll6 = ll6;
    }

    @Override
    public void ll7(List<Bitdef> ll7) {
        valueLeafFlags.set(LeafIdentifier.LL7.getLeafIndex());
        this.ll7 = ll7;
    }

    @Override
    public void ll8(List<byte[]> ll8) {
        valueLeafFlags.set(LeafIdentifier.LL8.getLeafIndex());
        this.ll8 = ll8;
    }

    @Override
    public void ll9(List<Id> ll9) {
        valueLeafFlags.set(LeafIdentifier.LL9.getLeafIndex());
        this.ll9 = ll9;
    }

    @Override
    public void modKey(List<ModKey> modKey) {
        this.modKey = modKey;
    }

    @Override
    public void type(List<Type> type) {
        this.type = type;
    }

    @Override
    public void val(Val val) {
        this.val = val;
    }

    @Override
    public void addToTri(Class<? extends YangAutoPrefixInt> addTo) {
        if (tri == null) {
            tri = new ArrayList<>();
        }
        tri.add(addTo);
    }


    @Override
    public void addToLl1(Ll1Union addTo) {
        if (ll1 == null) {
            ll1 = new ArrayList<>();
        }
        ll1.add(addTo);
    }


    @Override
    public void addToLl2(Class<? extends YangAutoPrefixInt> addTo) {
        if (ll2 == null) {
            ll2 = new ArrayList<>();
        }
        ll2.add(addTo);
    }


    @Override
    public void addToLl3(Tdef1 addTo) {
        if (ll3 == null) {
            ll3 = new ArrayList<>();
        }
        ll3.add(addTo);
    }


    @Override
    public void addToLl4(Class<? extends YangAutoPrefixInt> addTo) {
        if (ll4 == null) {
            ll4 = new ArrayList<>();
        }
        ll4.add(addTo);
    }


    @Override
    public void addToLl5(String addTo) {
        if (ll5 == null) {
            ll5 = new ArrayList<>();
        }
        ll5.add(addTo);
    }


    @Override
    public void addToLl6(Ll6Enum addTo) {
        if (ll6 == null) {
            ll6 = new ArrayList<>();
        }
        ll6.add(addTo);
    }


    @Override
    public void addToLl7(Bitdef addTo) {
        if (ll7 == null) {
            ll7 = new ArrayList<>();
        }
        ll7.add(addTo);
    }


    @Override
    public void addToLl8(byte[] addTo) {
        if (ll8 == null) {
            ll8 = new ArrayList<>();
        }
        ll8.add(addTo);
    }


    @Override
    public void addToLl9(Id addTo) {
        if (ll9 == null) {
            ll9 = new ArrayList<>();
        }
        ll9.add(addTo);
    }


    @Override
    public void addToModKey(ModKey addTo) {
        if (modKey == null) {
            modKey = new ArrayList<>();
        }
        modKey.add(addTo);
    }


    @Override
    public void addToType(Type addTo) {
        if (type == null) {
            type = new ArrayList<>();
        }
        type.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(tri, ll1, ll2, ll3, ll4, ll5, ll6, ll7, ll8, ll9, valueLeafFlags, modKey, type, val);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ModuleListAndKeyOpParam) {
            ModuleListAndKeyOpParam other = (ModuleListAndKeyOpParam) obj;
            return
                Objects.equals(tri, other.tri) &&
                Objects.equals(ll1, other.ll1) &&
                Objects.equals(ll2, other.ll2) &&
                Objects.equals(ll3, other.ll3) &&
                Objects.equals(ll4, other.ll4) &&
                Objects.equals(ll5, other.ll5) &&
                Objects.equals(ll6, other.ll6) &&
                Objects.equals(ll7, other.ll7) &&
                Objects.equals(ll8, other.ll8) &&
                Objects.equals(ll9, other.ll9) &&
                Objects.equals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.equals(modKey, other.modKey) &&
                Objects.equals(type, other.type) &&
                Objects.equals(val, other.val);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("tri=" + tri)
            .add("ll1=" + ll1)
            .add("ll2=" + ll2)
            .add("ll3=" + ll3)
            .add("ll4=" + ll4)
            .add("ll5=" + ll5)
            .add("ll6=" + ll6)
            .add("ll7=" + ll7)
            .add("ll8=" + ll8)
            .add("ll9=" + ll9)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("modKey=" + modKey)
            .add("type=" + type)
            .add("val=" + val)
            .toString();
    }

    /**
     * Creates an instance of moduleListAndKeyOpParam.
     */
    public ModuleListAndKeyOpParam() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }


    @Override
    public void addAugmentation(InnerModelObject obj) {
    }

    @Override
    public void removeAugmentation(InnerModelObject obj) {
    }

    @Override
    public Map<Class<? extends InnerModelObject>, InnerModelObject> augmentations() {

        return null;
    }

    @Override
    public <T extends InnerModelObject> T augmentation(Class<T> c) {

        return null;
    }
}