/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.modulelistandkey.rev20160826.modulelistandkey;

import org.onosproject.yang.gen.v1.modulelistandkey.rev20160826.modulelistandkey.tdef1.Tdef1Union;
import java.util.Objects;

/**
 * Represents the implementation of tdef1.
 */
public final class Tdef1 {

    private Tdef1Union union;

    /**
     * Creates an instance of tdef1.
     */
    private Tdef1() {
    }

    /**
     * Creates an instance of union.
     *
     * @param union value of union
     */
    public Tdef1(Tdef1Union union) {
        this.union = union;
    }

    /**
     * Returns the object of tdef1 for type union.
     *
     * @param value value of tdef1 for type union
     * @return tdef1 for type union
     */
    public static Tdef1 of(Tdef1Union value) {
        return new Tdef1(value);
    }

    /**
     * Returns the attribute union.
     *
     * @return union value of union
     */
    public Tdef1Union union() {
        return union;
    }
    /**
     * Sets the attribute union.
     *
     * @param union value of union
     */
    public void union(Tdef1Union union) {
        this.union = union;
    }

    @Override
    public int hashCode() {
        return Objects.hash(union);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Tdef1) {
            Tdef1 other = (Tdef1) obj;
            return
                Objects.equals(union, other.union);
        }
        return false;
    }

    @Override
    public String toString() {
        return union.toString();
    }
    /**
     * Returns the object of tdef1 fromString input String tdef1.
     *
     * @param valInString value of input String
     * @return tdef1
     */
    public static Tdef1 fromString(String valInString) {
        try {
            Tdef1Union tmpVal = Tdef1Union.fromString(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
