/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.modulelistandkey.rev20160826.modulelistandkey;

import org.onosproject.yang.gen.v1.modulelistandkey.rev20160826.modulelistandkey.type.Leaf1Union;
import org.onosproject.yang.gen.v1.modulelistandkey.rev20160826.modulelistandkey.YangAutoPrefixInt;
import org.onosproject.yang.gen.v1.modulelistandkey.rev20160826.modulelistandkey.Tdef1;
import org.onosproject.yang.gen.v1.modulelistandkey.rev20160826.modulelistandkey.YangAutoPrefixInt;
import java.lang.String;
import org.onosproject.yang.gen.v1.modulelistandkey.rev20160826.modulelistandkey.type.Leaf6Enum;
import org.onosproject.yang.gen.v1.modulelistandkey.rev20160826.modulelistandkey.Bitdef;
import org.onosproject.yang.gen.v1.modulelistandkey.rev20160826.modulelistandkey.Id;
import org.onosproject.yang.model.KeyInfo;
import java.util.Objects;

/**
 * Represents the implementation of type.
 */
public class TypeKeys implements KeyInfo<DefaultType> {
    protected Leaf1Union leaf1;
    protected Class<? extends YangAutoPrefixInt> leaf2;
    protected Tdef1 leaf3;
    protected Class<? extends YangAutoPrefixInt> leaf4;
    protected String leaf5;
    protected Leaf6Enum leaf6;
    protected Bitdef leaf7;
    protected byte[] leaf8;
    protected Id leaf9;
    /**
     * Returns the attribute leaf1.
     *
     * @return leaf1 value of leaf1
     */
    public Leaf1Union leaf1() {
        return leaf1;
    }

    /**
     * Sets the value to attribute leaf1.
     *
     * @param leaf1 value of leaf1
     */
    public void leaf1(Leaf1Union leaf1) {
        this.leaf1 = leaf1;
    }

    /**
     * Returns the attribute leaf2.
     *
     * @return leaf2 value of leaf2
     */
    public Class<? extends YangAutoPrefixInt> leaf2() {
        return leaf2;
    }

    /**
     * Sets the value to attribute leaf2.
     *
     * @param leaf2 value of leaf2
     */
    public void leaf2(Class<? extends YangAutoPrefixInt> leaf2) {
        this.leaf2 = leaf2;
    }

    /**
     * Returns the attribute leaf3.
     *
     * @return leaf3 value of leaf3
     */
    public Tdef1 leaf3() {
        return leaf3;
    }

    /**
     * Sets the value to attribute leaf3.
     *
     * @param leaf3 value of leaf3
     */
    public void leaf3(Tdef1 leaf3) {
        this.leaf3 = leaf3;
    }

    /**
     * Returns the attribute leaf4.
     *
     * @return leaf4 value of leaf4
     */
    public Class<? extends YangAutoPrefixInt> leaf4() {
        return leaf4;
    }

    /**
     * Sets the value to attribute leaf4.
     *
     * @param leaf4 value of leaf4
     */
    public void leaf4(Class<? extends YangAutoPrefixInt> leaf4) {
        this.leaf4 = leaf4;
    }

    /**
     * Returns the attribute leaf5.
     *
     * @return leaf5 value of leaf5
     */
    public String leaf5() {
        return leaf5;
    }

    /**
     * Sets the value to attribute leaf5.
     *
     * @param leaf5 value of leaf5
     */
    public void leaf5(String leaf5) {
        this.leaf5 = leaf5;
    }

    /**
     * Returns the attribute leaf6.
     *
     * @return leaf6 value of leaf6
     */
    public Leaf6Enum leaf6() {
        return leaf6;
    }

    /**
     * Sets the value to attribute leaf6.
     *
     * @param leaf6 value of leaf6
     */
    public void leaf6(Leaf6Enum leaf6) {
        this.leaf6 = leaf6;
    }

    /**
     * Returns the attribute leaf7.
     *
     * @return leaf7 value of leaf7
     */
    public Bitdef leaf7() {
        return leaf7;
    }

    /**
     * Sets the value to attribute leaf7.
     *
     * @param leaf7 value of leaf7
     */
    public void leaf7(Bitdef leaf7) {
        this.leaf7 = leaf7;
    }

    /**
     * Returns the attribute leaf8.
     *
     * @return leaf8 value of leaf8
     */
    public byte[] leaf8() {
        return leaf8;
    }

    /**
     * Sets the value to attribute leaf8.
     *
     * @param leaf8 value of leaf8
     */
    public void leaf8(byte[] leaf8) {
        this.leaf8 = leaf8;
    }

    /**
     * Returns the attribute leaf9.
     *
     * @return leaf9 value of leaf9
     */
    public Id leaf9() {
        return leaf9;
    }

    /**
     * Sets the value to attribute leaf9.
     *
     * @param leaf9 value of leaf9
     */
    public void leaf9(Id leaf9) {
        this.leaf9 = leaf9;
    }


    @Override
    public int hashCode() {
        return Objects.hash(leaf1, leaf2, leaf3, leaf4, leaf5, leaf6, leaf7, leaf8, leaf9);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TypeKeys) {
            TypeKeys other = (TypeKeys) obj;
            return
                Objects.equals(leaf1, other.leaf1) &&
                Objects.equals(leaf2, other.leaf2) &&
                Objects.equals(leaf3, other.leaf3) &&
                Objects.equals(leaf4, other.leaf4) &&
                Objects.equals(leaf5, other.leaf5) &&
                Objects.equals(leaf6, other.leaf6) &&
                Objects.equals(leaf7, other.leaf7) &&
                Objects.equals(leaf8, other.leaf8) &&
                Objects.equals(leaf9, other.leaf9);
        }
        return false;
    }
}