/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.modulelistandkey.rev20160826.modulelistandkey.tdef1.tdef1union;

/**
 * Represents ENUM data of tdef1UnionEnum1.
 */
public enum Tdef1UnionEnum1 {

    /**
     * Represents ten.
     */
    TEN(10, "ten"),

    /**
     * Represents hundred.
     */
    HUNDRED(100, "hundred"),

    /**
     * Represents thousand.
     */
    THOUSAND(1000, "thousand");

    private int tdef1UnionEnum1;
    private String schemaName;

    /**
     * Creates an instance of tdef1UnionEnum1.
     *
     * @param tdef1UnionEnum1 value of tdef1UnionEnum1
     */
     Tdef1UnionEnum1(int tdef1UnionEnum1, String schemaName) {
        this.tdef1UnionEnum1 = tdef1UnionEnum1;
        this.schemaName = schemaName;
    }

    /**
     * Returns the object of tdef1UnionEnum1 for.
     *
     * @param value value of tdef1UnionEnum1 for
     * @return tdef1UnionEnum1 for
     */
    public static Tdef1UnionEnum1 of(int value) {
        switch (value) {
            case 10:
                return Tdef1UnionEnum1.TEN;
            case 100:
                return Tdef1UnionEnum1.HUNDRED;
            case 1000:
                return Tdef1UnionEnum1.THOUSAND;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the object of tdef1UnionEnum1 for.
     *
     * @param value value of tdef1UnionEnum1 for
     * @return tdef1UnionEnum1 for
     */
    public static Tdef1UnionEnum1 of(String value) {
        switch (value) {
            case "ten":
                return Tdef1UnionEnum1.TEN;
            case "hundred":
                return Tdef1UnionEnum1.HUNDRED;
            case "thousand":
                return Tdef1UnionEnum1.THOUSAND;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the attribute tdef1UnionEnum1.
     *
     * @return tdef1UnionEnum1 value of tdef1UnionEnum1
     */
    public int tdef1UnionEnum1() {
        return tdef1UnionEnum1;
    }


    @Override
    public String toString() {
        return schemaName;
    }
}
