/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.modulelistandkeyaugment.rev20160826.modulelistandkeyaugment.modkey;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.modulelistandkeyaugment.rev20160826.modulelistandkeyaugment.modkey.augmentedschmodkey.AugListModKey;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of augmentedSchModKey.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultAugmentedSchModKey extends InnerModelObject implements AugmentedSchModKey {
    protected List<AugListModKey> augListModKey;

    @Override
    public List<AugListModKey> augListModKey() {
        return augListModKey;
    }

    @Override
    public void augListModKey(List<AugListModKey> augListModKey) {
        this.augListModKey = augListModKey;
    }

    @Override
    public void addToAugListModKey(AugListModKey addTo) {
        if (augListModKey == null) {
            augListModKey = new ArrayList<>();
        }
        augListModKey.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(augListModKey);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultAugmentedSchModKey) {
            DefaultAugmentedSchModKey other = (DefaultAugmentedSchModKey) obj;
            return
                Objects.equals(augListModKey, other.augListModKey);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("augListModKey=" + augListModKey)
            .toString();
    }


    /**
     * Creates an instance of defaultAugmentedSchModKey.
     */
    public DefaultAugmentedSchModKey() {
    }

}