/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.simpledatatypesll.rev20131112.simpledatatypesll.tpdfun2;

import org.onosproject.yang.gen.v1.simpledatatypesll.rev20131112.simpledatatypesll.Tpdfun3;
import org.onosproject.yang.gen.v1.simpledatatypesll.rev20131112.simpledatatypesll.Tpdfun4;
import java.util.Objects;
import java.util.BitSet;

/**
 * Represents the implementation of tpdfun2Union.
 */
public final class Tpdfun2Union {
    private Tpdfun3 tpdfun3;
    private Tpdfun4 tpdfun4;
    private BitSet setValue = new BitSet();

    /**
     * Creates an instance of tpdfun2Union.
     */
    private Tpdfun2Union() {
    }

    /**
     * Creates an instance of tpdfun3.
     *
     * @param tpdfun3 value of tpdfun3
     */
    public Tpdfun2Union(Tpdfun3 tpdfun3) {
        setValue.set(0);
        this.tpdfun3 = tpdfun3;
    }

    /**
     * Creates an instance of tpdfun4.
     *
     * @param tpdfun4 value of tpdfun4
     */
    public Tpdfun2Union(Tpdfun4 tpdfun4) {
        setValue.set(1);
        this.tpdfun4 = tpdfun4;
    }

    /**
     * Returns the object of tpdfun2Union for type tpdfun3.
     *
     * @param value value of tpdfun2Union for type tpdfun3
     * @return tpdfun2Union for type tpdfun3
     */
    public static Tpdfun2Union of(Tpdfun3 value) {
        return new Tpdfun2Union(value);
    }

    /**
     * Returns the object of tpdfun2Union for type tpdfun4.
     *
     * @param value value of tpdfun2Union for type tpdfun4
     * @return tpdfun2Union for type tpdfun4
     */
    public static Tpdfun2Union of(Tpdfun4 value) {
        return new Tpdfun2Union(value);
    }

    /**
     * Returns the attribute tpdfun3.
     *
     * @return tpdfun3 value of tpdfun3
     */
    public Tpdfun3 tpdfun3() {
        return tpdfun3;
    }
    /**
     * Returns the attribute tpdfun4.
     *
     * @return tpdfun4 value of tpdfun4
     */
    public Tpdfun4 tpdfun4() {
        return tpdfun4;
    }
    /**
     * Sets the attribute tpdfun3.
     *
     * @param tpdfun3 value of tpdfun3
     */
    public void tpdfun3(Tpdfun3 tpdfun3) {
        this.tpdfun3 = tpdfun3;
    }
    /**
     * Sets the attribute tpdfun4.
     *
     * @param tpdfun4 value of tpdfun4
     */
    public void tpdfun4(Tpdfun4 tpdfun4) {
        this.tpdfun4 = tpdfun4;
    }

    @Override
    public int hashCode() {
        return Objects.hash(tpdfun3, tpdfun4);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Tpdfun2Union) {
            Tpdfun2Union other = (Tpdfun2Union) obj;
            return
                Objects.equals(tpdfun3, other.tpdfun3) &&
                Objects.equals(tpdfun4, other.tpdfun4);
        }
        return false;
    }

    @Override
    public String toString() {
        if (setValue.get(0)) {
            return tpdfun3.toString();
        }
        if (setValue.get(1)) {
            return tpdfun4.toString();
        }
        return null;
    }
    /**
     * Returns the object of tpdfun2Union fromString input String tpdfun2Union.
     *
     * @param valInString value of input String
     * @return tpdfun2Union
     */
    public static Tpdfun2Union fromString(String valInString) {
        try {
            Tpdfun3 tmpVal = Tpdfun3.fromString(valInString);
            return of(tmpVal);
        } catch (Exception e) {
        }
        try {
            Tpdfun4 tmpVal = Tpdfun4.fromString(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
