/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yangautoprefixlist.rev20160624;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of list3.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class List3OpParam extends InnerModelObject implements List3 {
    protected List<String> leaf3;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public List<String> leaf3() {
        return leaf3;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void leaf3(List<String> leaf3) {
        valueLeafFlags.set(LeafIdentifier.LEAF3.getLeafIndex());
        this.leaf3 = leaf3;
    }

    @Override
    public void addToLeaf3(String addTo) {
        if (leaf3 == null) {
            leaf3 = new ArrayList<>();
        }
        leaf3.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(leaf3, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof List3OpParam) {
            List3OpParam other = (List3OpParam) obj;
            return
                Objects.equals(leaf3, other.leaf3) &&
                Objects.equals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("leaf3=" + leaf3)
            .add("valueLeafFlags=" + valueLeafFlags)
            .toString();
    }

    /**
     * Creates an instance of list3OpParam.
     */
    public List3OpParam() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }


    @Override
    public void addAugmentation(InnerModelObject obj) {
    }

    @Override
    public void removeAugmentation(InnerModelObject obj) {
    }

    @Override
    public Map<Class<? extends InnerModelObject>, InnerModelObject> augmentations() {

        return null;
    }

    @Override
    public <T extends InnerModelObject> T augmentation(Class<T> c) {

        return null;
    }
}