/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ymstopology.rev20140101.ymstopology;

import java.lang.String;
import org.onosproject.yang.model.KeyInfo;
import java.util.Objects;

/**
 * Represents the implementation of node.
 */
public class NodeKeys implements KeyInfo<DefaultNode> {
    protected String nodeId;
    /**
     * Returns the attribute nodeId.
     *
     * @return nodeId value of nodeId
     */
    public String nodeId() {
        return nodeId;
    }

    /**
     * Sets the value to attribute nodeId.
     *
     * @param nodeId value of nodeId
     */
    public void nodeId(String nodeId) {
        this.nodeId = nodeId;
    }


    @Override
    public int hashCode() {
        return Objects.hash(nodeId);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof NodeKeys) {
            NodeKeys other = (NodeKeys) obj;
            return
                Objects.equals(nodeId, other.nodeId);
        }
        return false;
    }
}