/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.informationsourceattributes;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.informationsourceattributes.informationsourcestate.Topology;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of informationSourceState.
 */
public interface InformationSourceState extends Augmentable  {

    /**
     * Identify the leaf of InformationSourceState.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents credibilityPreference.
         */
        CREDIBILITYPREFERENCE(1),
        /**
         * Represents routingInstance.
         */
        ROUTINGINSTANCE(2);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute credibilityPreference.
     *
     * @return credibilityPreference value of credibilityPreference
     */
    int credibilityPreference();

    /**
     * Returns the attribute routingInstance.
     *
     * @return routingInstance value of routingInstance
     */
    String routingInstance();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute topology.
     *
     * @return topology value of topology
     */
    Topology topology();

    /**
     * Sets the attribute credibilityPreference.
     *
     * @param credibilityPreference value of credibilityPreference
     */
    void credibilityPreference(int credibilityPreference);

    /**
     * Sets the attribute routingInstance.
     *
     * @param routingInstance value of routingInstance
     */
    void routingInstance(String routingInstance);

    /**
     * Sets the attribute topology.
     *
     * @param topology value of topology
     */
    void topology(Topology topology);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}