/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.tenodeinfoattributes;

import java.util.BitSet;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of underlayTopology.
 */
public interface UnderlayTopology extends Augmentable  {

    /**
     * Identify the leaf of UnderlayTopology.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents providerIdRef.
         */
        PROVIDERIDREF(1),
        /**
         * Represents clientIdRef.
         */
        CLIENTIDREF(2),
        /**
         * Represents teTopologyIdRef.
         */
        TETOPOLOGYIDREF(3),
        /**
         * Represents networkIdRef.
         */
        NETWORKIDREF(4);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute providerIdRef.
     *
     * @return providerIdRef value of providerIdRef
     */
    Object providerIdRef();

    /**
     * Returns the attribute clientIdRef.
     *
     * @return clientIdRef value of clientIdRef
     */
    Object clientIdRef();

    /**
     * Returns the attribute teTopologyIdRef.
     *
     * @return teTopologyIdRef value of teTopologyIdRef
     */
    Object teTopologyIdRef();

    /**
     * Returns the attribute networkIdRef.
     *
     * @return networkIdRef value of networkIdRef
     */
    Object networkIdRef();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Sets the attribute providerIdRef.
     *
     * @param providerIdRef value of providerIdRef
     */
    void providerIdRef(Object providerIdRef);

    /**
     * Sets the attribute clientIdRef.
     *
     * @param clientIdRef value of clientIdRef
     */
    void clientIdRef(Object clientIdRef);

    /**
     * Sets the attribute teTopologyIdRef.
     *
     * @param teTopologyIdRef value of teTopologyIdRef
     */
    void teTopologyIdRef(Object teTopologyIdRef);

    /**
     * Sets the attribute networkIdRef.
     *
     * @param networkIdRef value of networkIdRef
     */
    void networkIdRef(Object networkIdRef);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}