/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtsubscription.yrtsubscription;

import java.util.Objects;

/**
 * Represents the implementation of encoding.
 */
public final class Encoding {

    private Class<? extends Encodings> identityref;

    /**
     * Creates an instance of encoding.
     */
    private Encoding() {
    }

    /**
     * Creates an instance of identityref.
     *
     * @param identityref value of identityref
     */
    public Encoding(Class<? extends Encodings> identityref) {
        this.identityref = identityref;
    }

    /**
     * Returns the object of encoding for type identityref.
     *
     * @param value value of encoding for type identityref
     * @return encoding for type identityref
     */
    public static Encoding of(Class<? extends Encodings> value) {
        return new Encoding(value);
    }

    /**
     * Returns the attribute identityref.
     *
     * @return identityref value of identityref
     */
    public Class<? extends Encodings> identityref() {
        return identityref;
    }
    /**
     * Sets the attribute identityref.
     *
     * @param identityref value of identityref
     */
    public void identityref(Class<? extends Encodings> identityref) {
        this.identityref = identityref;
    }

    @Override
    public int hashCode() {
        return Objects.hash(identityref);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Encoding) {
            Encoding other = (Encoding) obj;
            return
                Objects.equals(identityref, other.identityref);
        }
        return false;
    }

    @Override
    public String toString() {
        return Encodings.encodingsToString();
    }
    /**
     * Returns the object of encoding fromString input String encoding.
     *
     * @param valInString value of input String
     * @return encoding
     */
    public static Encoding fromString(String valInString) {
        try {
            Class<? extends Encodings> tmpVal = Encodings.fromString(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
