/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtsubscription.yrtsubscription;

import java.util.Objects;

/**
 * Represents the implementation of subscriptionResultType.
 */
public final class SubscriptionResultType {

    private Class<? extends SubscriptionResult> identityref;

    /**
     * Creates an instance of subscriptionResultType.
     */
    private SubscriptionResultType() {
    }

    /**
     * Creates an instance of identityref.
     *
     * @param identityref value of identityref
     */
    public SubscriptionResultType(Class<? extends SubscriptionResult> identityref) {
        this.identityref = identityref;
    }

    /**
     * Returns the object of subscriptionResultType for type identityref.
     *
     * @param value value of subscriptionResultType for type identityref
     * @return subscriptionResultType for type identityref
     */
    public static SubscriptionResultType of(Class<? extends SubscriptionResult> value) {
        return new SubscriptionResultType(value);
    }

    /**
     * Returns the attribute identityref.
     *
     * @return identityref value of identityref
     */
    public Class<? extends SubscriptionResult> identityref() {
        return identityref;
    }
    /**
     * Sets the attribute identityref.
     *
     * @param identityref value of identityref
     */
    public void identityref(Class<? extends SubscriptionResult> identityref) {
        this.identityref = identityref;
    }

    @Override
    public int hashCode() {
        return Objects.hash(identityref);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SubscriptionResultType) {
            SubscriptionResultType other = (SubscriptionResultType) obj;
            return
                Objects.equals(identityref, other.identityref);
        }
        return false;
    }

    @Override
    public String toString() {
        return SubscriptionResult.subscriptionResultToString();
    }
    /**
     * Returns the object of subscriptionResultType fromString input String subscriptionResultType.
     *
     * @param valInString value of input String
     * @return subscriptionResultType
     */
    public static SubscriptionResultType fromString(String valInString) {
        try {
            Class<? extends SubscriptionResult> tmpVal = SubscriptionResult.fromString(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
