/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtsubscription.yrtsubscription;
/**
 * Represents the implementation of subscriptionStatus.
 */
public abstract class SubscriptionStatus {

    /**
     * Returns the attribute subscription-status.
     *
     * @return subscription-status value of subscription-status
     */
    public static String subscriptionStatusToString() {
        return "subscription-status";
    }

    /**
     * Returns the object of subscriptionStatus fromString input String subscriptionStatus.
     *
     * @param valInString value of input String
     * @return subscriptionStatus
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("subscription-status")) {
            return SubscriptionStatus.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}