/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtsubscription.yrtsubscription.receiverinfo;

import java.util.List;
import org.onosproject.yang.gen.v1.yrtsubscription.yrtsubscription.receiverinfo.receivers.Receiver;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of receivers.
 */
public interface Receivers extends Augmentable  {

    /**
     * Returns the attribute receiver.
     *
     * @return receiver list of receiver
     */
    List<Receiver> receiver();

    /**
     * Sets the attribute receiver.
     *
     * @param receiver list of receiver
     */
    void receiver(List<Receiver> receiver);

    /**
     * Adds to the list of receiver.
     *
     * @param addTo value of receiver
     */
    void addToReceiver(Receiver addTo);

}