/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ytbdatatype.rev20160826.ytbdatatype;

import java.util.Objects;

/**
 * Represents the implementation of enumDer1.
 */
public final class EnumDer1 {

    private EnumDer2 enumDer2;

    /**
     * Creates an instance of enumDer1.
     */
    private EnumDer1() {
    }

    /**
     * Creates an instance of enumDer2.
     *
     * @param enumDer2 value of enumDer2
     */
    public EnumDer1(EnumDer2 enumDer2) {
        this.enumDer2 = enumDer2;
    }

    /**
     * Returns the object of enumDer1 for type enumDer2.
     *
     * @param value value of enumDer1 for type enumDer2
     * @return enumDer1 for type enumDer2
     */
    public static EnumDer1 of(EnumDer2 value) {
        return new EnumDer1(value);
    }

    /**
     * Returns the attribute enumDer2.
     *
     * @return enumDer2 value of enumDer2
     */
    public EnumDer2 enumDer2() {
        return enumDer2;
    }
    /**
     * Sets the attribute enumDer2.
     *
     * @param enumDer2 value of enumDer2
     */
    public void enumDer2(EnumDer2 enumDer2) {
        this.enumDer2 = enumDer2;
    }

    @Override
    public int hashCode() {
        return Objects.hash(enumDer2);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof EnumDer1) {
            EnumDer1 other = (EnumDer1) obj;
            return
                Objects.equals(enumDer2, other.enumDer2);
        }
        return false;
    }

    @Override
    public String toString() {
        return enumDer2.toString();
    }
    /**
     * Returns the object of enumDer1 fromString input String enumDer1.
     *
     * @param valInString value of input String
     * @return enumDer1
     */
    public static EnumDer1 fromString(String valInString) {
        try {
            EnumDer2 tmpVal = EnumDer2.fromString(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
