/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ytbdatatype.rev20160826.ytbdatatype;

import org.onosproject.yang.gen.v1.ytbdatatype.rev20160826.ytbdatatype.enumder2.EnumDer2Enum;
import java.util.Objects;

/**
 * Represents the implementation of enumDer2.
 */
public final class EnumDer2 {

    private EnumDer2Enum enumeration;

    /**
     * Creates an instance of enumDer2.
     */
    private EnumDer2() {
    }

    /**
     * Creates an instance of enumeration.
     *
     * @param enumeration value of enumeration
     */
    public EnumDer2(EnumDer2Enum enumeration) {
        this.enumeration = enumeration;
    }

    /**
     * Returns the object of enumDer2 for type enumeration.
     *
     * @param value value of enumDer2 for type enumeration
     * @return enumDer2 for type enumeration
     */
    public static EnumDer2 of(EnumDer2Enum value) {
        return new EnumDer2(value);
    }

    /**
     * Returns the attribute enumeration.
     *
     * @return enumeration value of enumeration
     */
    public EnumDer2Enum enumeration() {
        return enumeration;
    }
    /**
     * Sets the attribute enumeration.
     *
     * @param enumeration value of enumeration
     */
    public void enumeration(EnumDer2Enum enumeration) {
        this.enumeration = enumeration;
    }

    @Override
    public int hashCode() {
        return Objects.hash(enumeration);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof EnumDer2) {
            EnumDer2 other = (EnumDer2) obj;
            return
                Objects.equals(enumeration, other.enumeration);
        }
        return false;
    }

    @Override
    public String toString() {
        return enumeration.toString();
    }
    /**
     * Returns the object of enumDer2 fromString input String enumDer2.
     *
     * @param valInString value of input String
     * @return enumDer2
     */
    public static EnumDer2 fromString(String valInString) {
        try {
            EnumDer2Enum tmpVal = EnumDer2Enum.of(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
