/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ytbemptytype.rev20160826;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.ytbemptytype.rev20160826.ytbemptytype.EmpType;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of ytbEmptyType.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class YtbEmptyTypeOpParam extends InnerModelObject implements YtbEmptyType {
    protected boolean empty;
    protected boolean emptyRef;
    protected EmpType emptyType;
    protected boolean emptyRefType;
    protected List<Boolean> emptyList;
    protected List<Boolean> emptyListRef;
    protected List<EmpType> emptyListType;
    protected List<Boolean> emptyListRefType;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public boolean empty() {
        return empty;
    }

    @Override
    public boolean emptyRef() {
        return emptyRef;
    }

    @Override
    public EmpType emptyType() {
        return emptyType;
    }

    @Override
    public boolean emptyRefType() {
        return emptyRefType;
    }

    @Override
    public List<Boolean> emptyList() {
        return emptyList;
    }

    @Override
    public List<Boolean> emptyListRef() {
        return emptyListRef;
    }

    @Override
    public List<EmpType> emptyListType() {
        return emptyListType;
    }

    @Override
    public List<Boolean> emptyListRefType() {
        return emptyListRefType;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void empty(boolean empty) {
        valueLeafFlags.set(LeafIdentifier.EMPTY.getLeafIndex());
        this.empty = empty;
    }

    @Override
    public void emptyRef(boolean emptyRef) {
        valueLeafFlags.set(LeafIdentifier.EMPTYREF.getLeafIndex());
        this.emptyRef = emptyRef;
    }

    @Override
    public void emptyType(EmpType emptyType) {
        valueLeafFlags.set(LeafIdentifier.EMPTYTYPE.getLeafIndex());
        this.emptyType = emptyType;
    }

    @Override
    public void emptyRefType(boolean emptyRefType) {
        valueLeafFlags.set(LeafIdentifier.EMPTYREFTYPE.getLeafIndex());
        this.emptyRefType = emptyRefType;
    }

    @Override
    public void emptyList(List<Boolean> emptyList) {
        valueLeafFlags.set(LeafIdentifier.EMPTYLIST.getLeafIndex());
        this.emptyList = emptyList;
    }

    @Override
    public void emptyListRef(List<Boolean> emptyListRef) {
        valueLeafFlags.set(LeafIdentifier.EMPTYLISTREF.getLeafIndex());
        this.emptyListRef = emptyListRef;
    }

    @Override
    public void emptyListType(List<EmpType> emptyListType) {
        valueLeafFlags.set(LeafIdentifier.EMPTYLISTTYPE.getLeafIndex());
        this.emptyListType = emptyListType;
    }

    @Override
    public void emptyListRefType(List<Boolean> emptyListRefType) {
        valueLeafFlags.set(LeafIdentifier.EMPTYLISTREFTYPE.getLeafIndex());
        this.emptyListRefType = emptyListRefType;
    }

    @Override
    public void addToEmptyList(Boolean addTo) {
        if (emptyList == null) {
            emptyList = new ArrayList<>();
        }
        emptyList.add(addTo);
    }


    @Override
    public void addToEmptyListRef(Boolean addTo) {
        if (emptyListRef == null) {
            emptyListRef = new ArrayList<>();
        }
        emptyListRef.add(addTo);
    }


    @Override
    public void addToEmptyListType(EmpType addTo) {
        if (emptyListType == null) {
            emptyListType = new ArrayList<>();
        }
        emptyListType.add(addTo);
    }


    @Override
    public void addToEmptyListRefType(Boolean addTo) {
        if (emptyListRefType == null) {
            emptyListRefType = new ArrayList<>();
        }
        emptyListRefType.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(empty, emptyRef, emptyType, emptyRefType, emptyList, emptyListRef, emptyListType, emptyListRefType, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof YtbEmptyTypeOpParam) {
            YtbEmptyTypeOpParam other = (YtbEmptyTypeOpParam) obj;
            return
                Objects.equals(empty, other.empty) &&
                Objects.equals(emptyRef, other.emptyRef) &&
                Objects.equals(emptyType, other.emptyType) &&
                Objects.equals(emptyRefType, other.emptyRefType) &&
                Objects.equals(emptyList, other.emptyList) &&
                Objects.equals(emptyListRef, other.emptyListRef) &&
                Objects.equals(emptyListType, other.emptyListType) &&
                Objects.equals(emptyListRefType, other.emptyListRefType) &&
                Objects.equals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("empty=" + empty)
            .add("emptyRef=" + emptyRef)
            .add("emptyType=" + emptyType)
            .add("emptyRefType=" + emptyRefType)
            .add("emptyList=" + emptyList)
            .add("emptyListRef=" + emptyListRef)
            .add("emptyListType=" + emptyListType)
            .add("emptyListRefType=" + emptyListRefType)
            .add("valueLeafFlags=" + valueLeafFlags)
            .toString();
    }

    /**
     * Creates an instance of ytbEmptyTypeOpParam.
     */
    public YtbEmptyTypeOpParam() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }


    @Override
    public void addAugmentation(InnerModelObject obj) {
    }

    @Override
    public void removeAugmentation(InnerModelObject obj) {
    }

    @Override
    public Map<Class<? extends InnerModelObject>, InnerModelObject> augmentations() {

        return null;
    }

    @Override
    public <T extends InnerModelObject> T augmentation(Class<T> c) {

        return null;
    }
}