/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ytbmultimoduleb.rev20160826.ytbmultimoduleb;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.model.InnerModelObject;
import org.onosproject.yang.model.MultiInstanceObject;

/**
 * Represents the implementation of ytbmultilistb.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultYtbmultilistb extends InnerModelObject 
        implements Ytbmultilistb, MultiInstanceObject<YtbmultilistbKeys> {
    protected List<String> checkin;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public List<String> checkin() {
        return checkin;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void checkin(List<String> checkin) {
        valueLeafFlags.set(LeafIdentifier.CHECKIN.getLeafIndex());
        this.checkin = checkin;
    }

    @Override
    public void addToCheckin(String addTo) {
        if (checkin == null) {
            checkin = new ArrayList<>();
        }
        checkin.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(checkin, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultYtbmultilistb) {
            DefaultYtbmultilistb other = (DefaultYtbmultilistb) obj;
            return
                Objects.equals(checkin, other.checkin) &&
                Objects.equals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("checkin=" + checkin)
            .add("valueLeafFlags=" + valueLeafFlags)
            .toString();
    }


    /**
     * Creates an instance of defaultYtbmultilistb.
     */
    public DefaultYtbmultilistb() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}