/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.parser.impl.parserutils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.ParserRuleContext;
import org.onosproject.yang.compiler.datamodel.YangAtomicPath;
import org.onosproject.yang.compiler.datamodel.YangImport;
import org.onosproject.yang.compiler.datamodel.YangLeafRef;
import org.onosproject.yang.compiler.datamodel.YangModule;
import org.onosproject.yang.compiler.datamodel.YangNode;
import org.onosproject.yang.compiler.datamodel.YangNodeIdentifier;
import org.onosproject.yang.compiler.datamodel.YangPathArgType;
import org.onosproject.yang.compiler.datamodel.YangPathOperator;
import org.onosproject.yang.compiler.datamodel.YangPathPredicate;
import org.onosproject.yang.compiler.datamodel.YangReferenceResolver;
import org.onosproject.yang.compiler.datamodel.YangRelativePath;
import org.onosproject.yang.compiler.datamodel.YangSubModule;
import org.onosproject.yang.compiler.datamodel.YangUniqueHolder;
import org.onosproject.yang.compiler.datamodel.utils.YangConstructType;
import org.onosproject.yang.compiler.parser.antlrgencode.GeneratedYangParser;
import org.onosproject.yang.compiler.parser.exceptions.ParserException;
import org.onosproject.yang.compiler.utils.UtilConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ListenerUtil {
    public static final String SPACE = " ";
    public static final String LINE_NUMBER = "line number ";
    public static final String CHARACTER_POSITION = "character position ";
    public static final String FILE = "file ";
    private static final Logger log = LoggerFactory.getLogger(ListenerUtil.class);
    private static final Pattern IDENTIFIER_PATTERN = Pattern.compile("[a-zA-Z_][a-zA-Z0-9_.-]*");
    private static final String DATE_PATTERN = "[0-9]{4}-([0-9]{2}|[0-9])-([0-9]{2}|[0-9])";
    private static final String NON_NEGATIVE_INTEGER_PATTERN = "[0-9]+";
    private static final Pattern INTEGER_PATTERN = Pattern.compile("[-][0-9]+|[0-9]+");
    private static final Pattern PREDICATE = Pattern.compile("\\[(.*?)\\]");
    private static final String XML = "xml";
    private static final String ONE = "1";
    private static final int IDENTIFIER_LENGTH = 64;
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final String REGEX_EQUAL = "[=]";
    private static final String REGEX_OPEN_BRACE = "[(]";
    private static final String E_DES_NODE = "YANG file error : The reference path of descendant schema is not pointing to node inside itself";
    private static final String E_DES_FORMAT = "YANG file error : The descendant path must not start with a slash(/)";

    private ListenerUtil() {
    }

    public static String removeQuotesAndHandleConcat(String yangStringData) {
        yangStringData = yangStringData.replaceAll("['\"]", "");
        String[] tmpData = yangStringData.split(Pattern.quote("+"));
        StringBuilder builder = new StringBuilder();
        for (String yangString : tmpData) {
            builder.append(yangString);
        }
        return builder.toString();
    }

    public static String getValidIdentifier(String identifier, YangConstructType yangConstruct, ParserRuleContext ctx) {
        ParserException parserException;
        String identifierString = ListenerUtil.removeQuotesAndHandleConcat(identifier);
        if (identifierString.length() > 64) {
            parserException = new ParserException("YANG file error : " + YangConstructType.getYangConstructType(yangConstruct) + " name " + identifierString + " is greater than 64 characters.");
        } else if (!IDENTIFIER_PATTERN.matcher(identifierString).matches()) {
            parserException = new ParserException("YANG file error : " + YangConstructType.getYangConstructType(yangConstruct) + " name " + identifierString + " is not valid.");
        } else if (identifierString.toLowerCase().startsWith(XML)) {
            parserException = new ParserException("YANG file error : " + YangConstructType.getYangConstructType(yangConstruct) + " identifier " + identifierString + " must not start with (('X'|'x') ('M'|'m') ('L'|'l')).");
        } else {
            return identifierString;
        }
        parserException.setLine(ctx.getStart().getLine());
        parserException.setCharPosition(ctx.getStart().getCharPositionInLine());
        throw parserException;
    }

    public static boolean isDateValid(String dateToValidate) {
        if (dateToValidate == null || !dateToValidate.matches(DATE_PATTERN)) {
            return false;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        sdf.setLenient(false);
        try {
            sdf.parse(dateToValidate);
        }
        catch (ParseException e) {
            return false;
        }
        return true;
    }

    public static byte getValidVersion(GeneratedYangParser.YangVersionStatementContext ctx) {
        String value = ListenerUtil.removeQuotesAndHandleConcat(ctx.version().getText());
        if (!value.equals(ONE)) {
            ParserException parserException = new ParserException("YANG file error: Input version not supported");
            parserException.setLine(ctx.getStart().getLine());
            parserException.setCharPosition(ctx.getStart().getCharPositionInLine());
            throw parserException;
        }
        return Byte.valueOf(value);
    }

    public static int getValidNonNegativeIntegerValue(String integerValue, YangConstructType yangConstruct, ParserRuleContext ctx) {
        int valueInInteger;
        String value = ListenerUtil.removeQuotesAndHandleConcat(integerValue);
        if (!value.matches(NON_NEGATIVE_INTEGER_PATTERN)) {
            ParserException parserException = new ParserException("YANG file error : " + YangConstructType.getYangConstructType(yangConstruct) + " value " + value + " is not valid.");
            parserException.setLine(ctx.getStart().getLine());
            parserException.setCharPosition(ctx.getStart().getCharPositionInLine());
            throw parserException;
        }
        try {
            valueInInteger = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            ParserException parserException = new ParserException("YANG file error : " + YangConstructType.getYangConstructType(yangConstruct) + " value " + value + " is not valid.");
            parserException.setLine(ctx.getStart().getLine());
            parserException.setCharPosition(ctx.getStart().getCharPositionInLine());
            throw parserException;
        }
        return valueInInteger;
    }

    public static int getValidIntegerValue(String integerValue, YangConstructType yangConstruct, ParserRuleContext ctx) {
        int valueInInteger;
        String value = ListenerUtil.removeQuotesAndHandleConcat(integerValue);
        if (!INTEGER_PATTERN.matcher(value).matches()) {
            ParserException parserException = new ParserException("YANG file error : " + YangConstructType.getYangConstructType(yangConstruct) + " value " + value + " is not valid.");
            parserException.setLine(ctx.getStart().getLine());
            parserException.setCharPosition(ctx.getStart().getCharPositionInLine());
            throw parserException;
        }
        try {
            valueInInteger = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            ParserException parserException = new ParserException("YANG file error : " + YangConstructType.getYangConstructType(yangConstruct) + " value " + value + " is not valid.");
            parserException.setLine(ctx.getStart().getLine());
            parserException.setCharPosition(ctx.getStart().getCharPositionInLine());
            throw parserException;
        }
        return valueInInteger;
    }

    public static boolean getValidBooleanValue(String booleanValue, YangConstructType yangConstruct, ParserRuleContext ctx) {
        String value = ListenerUtil.removeQuotesAndHandleConcat(booleanValue);
        if (value.equals("true")) {
            return true;
        }
        if (value.equals("false")) {
            return false;
        }
        ParserException parserException = new ParserException("YANG file error : " + YangConstructType.getYangConstructType(yangConstruct) + " value " + value + " is not valid.");
        parserException.setLine(ctx.getStart().getLine());
        parserException.setCharPosition(ctx.getStart().getCharPositionInLine());
        throw parserException;
    }

    public static Date getCurrentDateForRevision() {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
        Date date = new Date();
        String dateInString = dateFormat.format(date);
        try {
            Date now = dateFormat.parse(dateInString);
            return date;
        }
        catch (ParseException e) {
            ParserException parserException = new ParserException("YANG file error: Input date is not correct");
            throw parserException;
        }
    }

    public static YangNodeIdentifier getValidNodeIdentifier(String nodeIdentifierString, YangConstructType yangConstruct, ParserRuleContext ctx) {
        String tmpIdentifierString = ListenerUtil.removeQuotesAndHandleConcat(nodeIdentifierString);
        String[] tmpData = tmpIdentifierString.split(Pattern.quote(":"));
        if (tmpData.length == 1) {
            YangNodeIdentifier nodeIdentifier = new YangNodeIdentifier();
            nodeIdentifier.setName(ListenerUtil.getValidIdentifier(tmpData[0], yangConstruct, ctx));
            return nodeIdentifier;
        }
        if (tmpData.length == 2) {
            YangNodeIdentifier nodeIdentifier = new YangNodeIdentifier();
            nodeIdentifier.setPrefix(ListenerUtil.getValidIdentifier(tmpData[0], yangConstruct, ctx));
            nodeIdentifier.setName(ListenerUtil.getValidIdentifier(tmpData[1], yangConstruct, ctx));
            return nodeIdentifier;
        }
        ParserException parserException = new ParserException("YANG file error : " + YangConstructType.getYangConstructType(yangConstruct) + " name " + nodeIdentifierString + " is not valid.");
        parserException.setLine(ctx.getStart().getLine());
        parserException.setCharPosition(ctx.getStart().getCharPositionInLine());
        throw parserException;
    }

    private static void valPrefix(List<YangAtomicPath> atomicList, YangLeafRef leafRef) {
        for (YangAtomicPath atomicPath : atomicList) {
            String prefix = atomicPath.getNodeIdentifier().getPrefix();
            YangNode parent = leafRef.getParentNode();
            YangNode rootNode = ListenerUtil.getRootNode(parent);
            List<YangImport> imports = rootNode instanceof YangModule ? ((YangModule)rootNode).getImportList() : ((YangSubModule)rootNode).getImportList();
            ListenerUtil.updatePrefixWithNode(rootNode, imports, prefix, leafRef);
        }
    }

    private static void updatePrefixWithNode(YangNode root, List<YangImport> imports, String prefix, YangLeafRef<?> leafRef) {
        Map<String, String> prefixMap = leafRef.getPrefixAndNode();
        if (prefixMap == null) {
            prefixMap = new HashMap<String, String>();
            leafRef.setPrefixAndNode(prefixMap);
        }
        if (prefix == null || prefix.equals(((YangReferenceResolver)((Object)root)).getPrefix())) {
            prefixMap.put(prefix, root.getName());
            return;
        }
        if (imports != null) {
            for (YangImport yangImp : imports) {
                if (!yangImp.getPrefixId().equals(prefix)) continue;
                prefixMap.put(prefix, yangImp.getModuleName());
            }
        }
    }

    private static YangNode getRootNode(YangNode node) {
        YangNode curNode = node;
        while (!(curNode instanceof YangModule) && !(curNode instanceof YangSubModule)) {
            if (curNode == null) {
                throw new ParserException("Internal datamodel error: Datamodel tree is not correct");
            }
            curNode = curNode.getParent();
        }
        return curNode;
    }

    public static List<YangAtomicPath> parseUsesAugment(YangNode uses, GeneratedYangParser.AugmentStatementContext ctx) {
        String val = ListenerUtil.removeQuotesAndHandleConcat(ctx.augment().getText());
        String rootPre = ListenerUtil.getRootPrefix(uses);
        return ListenerUtil.validateDesSchemaNode(val, rootPre, ctx, YangConstructType.AUGMENT_DATA);
    }

    private static List<YangAtomicPath> validateDesSchemaNode(String val, String prefix, ParserRuleContext ctx, YangConstructType type) {
        String[] path;
        if (val.startsWith("/")) {
            ParserException exc = new ParserException(E_DES_FORMAT);
            exc.setLine(ctx.getStart().getLine());
            exc.setCharPosition(ctx.getStart().getCharPositionInLine());
            throw exc;
        }
        LinkedList<YangAtomicPath> pathList = new LinkedList<YangAtomicPath>();
        for (String uniVal : path = val.split("/")) {
            YangAtomicPath atomicPath = new YangAtomicPath();
            YangNodeIdentifier id = ListenerUtil.getValidNodeIdentifier(uniVal, type, ctx);
            atomicPath.setNodeIdentifier(id);
            pathList.add(atomicPath);
            if (id.getPrefix() == null || id.getPrefix().equals(prefix)) continue;
            ParserException exc = new ParserException(E_DES_NODE);
            exc.setLine(ctx.getStart().getLine());
            exc.setCharPosition(ctx.getStart().getCharPositionInLine());
            throw exc;
        }
        return pathList;
    }

    public static void addUniqueHolderToRoot(YangUniqueHolder holder) {
        List<List<YangAtomicPath>> uniques = holder.getPathList();
        if (uniques != null && !uniques.isEmpty()) {
            YangReferenceResolver root = (YangReferenceResolver)((Object)ListenerUtil.getRootNode((YangNode)((Object)holder)));
            root.addToUniqueHolderList(holder);
        }
    }

    public static List<YangAtomicPath> validateUniqueInList(YangUniqueHolder holder, String val, ParserRuleContext ctx) {
        YangNode node = (YangNode)((Object)holder);
        String rootPre = ListenerUtil.getRootPrefix(node);
        return ListenerUtil.validateDesSchemaNode(val, rootPre, ctx, YangConstructType.UNIQUE_DATA);
    }

    private static String getRootPrefix(YangNode curNode) {
        String prefix;
        YangNode node = ListenerUtil.getRootNode(curNode);
        if (node instanceof YangModule) {
            YangModule yangModule = (YangModule)node;
            prefix = yangModule.getPrefix();
        } else {
            YangSubModule yangSubModule = (YangSubModule)node;
            prefix = yangSubModule.getPrefix();
        }
        return prefix;
    }

    private static String getMatchedPredicate(String str) {
        Matcher matcher = PREDICATE.matcher(str);
        if (matcher.find()) {
            return matcher.group(0);
        }
        return null;
    }

    public static List<YangAtomicPath> getValidAbsoluteSchemaNodeId(String argumentString, YangConstructType yangConstructType, ParserRuleContext ctx) {
        String[] tmpData;
        ArrayList<YangAtomicPath> targetNodes = new ArrayList<YangAtomicPath>();
        String tmpSchemaNodeId = ListenerUtil.removeQuotesAndHandleConcat(argumentString);
        if (!tmpSchemaNodeId.startsWith(UtilConstants.SLASH)) {
            ParserException parserException = new ParserException("YANG file error : " + YangConstructType.getYangConstructType(yangConstructType) + " name " + argumentString + "is not valid");
            parserException.setLine(ctx.getStart().getLine());
            parserException.setCharPosition(ctx.getStart().getCharPositionInLine());
            throw parserException;
        }
        for (String nodeIdentifiers : tmpData = tmpSchemaNodeId.replaceFirst("^" + UtilConstants.SLASH, "").split(UtilConstants.SLASH)) {
            YangNodeIdentifier yangNodeIdentifier = ListenerUtil.getValidNodeIdentifier(nodeIdentifiers, yangConstructType, ctx);
            YangAtomicPath yangAbsPath = new YangAtomicPath();
            yangAbsPath.setNodeIdentifier(yangNodeIdentifier);
            targetNodes.add(yangAbsPath);
        }
        return targetNodes;
    }

    public static void handleUnsupportedYangConstruct(YangConstructType type, ParserRuleContext ctx, String errorInfo, String fileName, String identifier) {
        StringBuilder b = new StringBuilder();
        int lineNumber = ctx.getStart().getLine();
        int charPostion = ctx.getStart().getCharPositionInLine();
        b.append("YANG file error : ").append("\"").append(YangConstructType.getYangConstructType(type)).append(SPACE).append(identifier).append("\"").append(" at ").append(LINE_NUMBER).append(lineNumber).append(" at ").append(CHARACTER_POSITION).append(charPostion).append(" in ").append(FILE).append(fileName).append(errorInfo);
        log.info(b.toString());
    }

    public static Date getValidDateFromString(String dateInString, ParserRuleContext ctx) {
        String dateArgument = ListenerUtil.removeQuotesAndHandleConcat(dateInString);
        if (!dateArgument.matches(DATE_PATTERN)) {
            ParserException parserException = new ParserException("YANG file error: Input date is not correct");
            parserException.setLine(ctx.getStart().getLine());
            parserException.setCharPosition(ctx.getStart().getCharPositionInLine());
            throw parserException;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        sdf.setLenient(false);
        try {
            return sdf.parse(dateArgument);
        }
        catch (ParseException e) {
            ParserException parserException = new ParserException("YANG file error: Input date is not correct");
            parserException.setLine(ctx.getStart().getLine());
            parserException.setCharPosition(ctx.getStart().getCharPositionInLine());
            throw parserException;
        }
    }

    public static String getValidPrefix(String inputString, YangConstructType yangConstruct, ParserRuleContext ctx) {
        String tmpPrefixString = ListenerUtil.removeQuotesAndHandleConcat(inputString);
        String[] tmpData = tmpPrefixString.split(Pattern.quote(":"));
        if (tmpData.length == 2) {
            return tmpData[0];
        }
        ParserException parserException = new ParserException("YANG file error : " + YangConstructType.getYangConstructType(yangConstruct) + " name " + inputString + " is not valid.");
        parserException.setLine(ctx.getStart().getLine());
        parserException.setCharPosition(ctx.getStart().getCharPositionInLine());
        throw parserException;
    }

    public static void validatePath(String path, YangConstructType type, GeneratedYangParser.PathStatementContext ctx, YangLeafRef leafRef) {
        String concatPath = ListenerUtil.removeQuotesAndHandleConcat(path);
        if (!concatPath.startsWith("/") && !concatPath.startsWith("..")) {
            throw ListenerUtil.getPathException(ctx, leafRef);
        }
        leafRef.setPath(concatPath);
        if (concatPath.startsWith("/")) {
            LinkedList<YangAtomicPath> atomicList = new LinkedList<YangAtomicPath>();
            ListenerUtil.valAbsPath(concatPath, atomicList, ctx, leafRef, type);
            leafRef.setPathType(YangPathArgType.ABSOLUTE_PATH);
            ListenerUtil.valPrefix(atomicList, leafRef);
            leafRef.setAtomicPath(atomicList);
            return;
        }
        leafRef.setPathType(YangPathArgType.RELATIVE_PATH);
        ListenerUtil.valRelPath(concatPath, leafRef, ctx, type);
    }

    private static void valRelPath(String path, YangLeafRef leafRef, GeneratedYangParser.PathStatementContext pathCtx, YangConstructType pathType) {
        YangRelativePath relPath = new YangRelativePath();
        int count = 0;
        while (path.startsWith("../")) {
            path = path.replaceFirst("../", "");
            ++count;
        }
        if (path.isEmpty()) {
            throw ListenerUtil.getPathException(pathCtx, leafRef);
        }
        ArrayList<YangAtomicPath> atomicList = new ArrayList<YangAtomicPath>();
        relPath.setAncestorNodeCount(count);
        ListenerUtil.valAbsPath("/" + path, atomicList, pathCtx, leafRef, pathType);
        ListenerUtil.valPrefix(atomicList, leafRef);
        relPath.setAtomicPathList(atomicList);
        leafRef.setRelativePath(relPath);
    }

    private static void valAbsPath(String path, List<YangAtomicPath> atomics, GeneratedYangParser.PathStatementContext pathCtx, YangLeafRef yangLeafRef, YangConstructType pathType) {
        String comPath = path;
        while (comPath != null) {
            if ((comPath = comPath.substring(1)).isEmpty()) {
                throw ListenerUtil.getPathException(pathCtx, yangLeafRef);
            }
            int nodeId = comPath.indexOf(47);
            int predicate = comPath.indexOf(91);
            if (predicate < nodeId && predicate != -1) {
                comPath = ListenerUtil.getPathWithPredicate(comPath, atomics, pathCtx, yangLeafRef, pathType);
                continue;
            }
            comPath = ListenerUtil.getPath(comPath, atomics, pathType, pathCtx);
        }
    }

    private static String getPathWithPredicate(String path, List<YangAtomicPath> atomics, GeneratedYangParser.PathStatementContext pathCtx, YangLeafRef yangLeafRef, YangConstructType pathType) {
        String[] node = new String[2];
        int bracket = path.indexOf(91);
        node[0] = path.substring(0, bracket);
        node[1] = path.substring(bracket);
        return ListenerUtil.getParsedPath(node[0], node[1], atomics, pathCtx, yangLeafRef, pathType);
    }

    public static String getParsedPath(String nodeId, String path, List<YangAtomicPath> atomics, GeneratedYangParser.PathStatementContext pathCtx, YangLeafRef yangLeafRef, YangConstructType pathType) {
        String comPath = path;
        ArrayList<String> predicateList = new ArrayList<String>();
        while (comPath.startsWith("[")) {
            String matchedVal = ListenerUtil.getMatchedPredicate(comPath);
            if (matchedVal == null || matchedVal.isEmpty()) {
                throw ListenerUtil.getPathException(pathCtx, yangLeafRef);
            }
            predicateList.add(matchedVal);
            comPath = comPath.substring(matchedVal.length());
        }
        YangAtomicPath atomicPath = new YangAtomicPath();
        YangNodeIdentifier validId = ListenerUtil.getValidNodeIdentifier(nodeId, pathType, pathCtx);
        List<YangPathPredicate> predicates = ListenerUtil.valPathPredicates(predicateList, pathType, pathCtx, yangLeafRef);
        atomicPath.setNodeIdentifier(validId);
        atomicPath.setPathPredicatesList(predicates);
        atomics.add(atomicPath);
        return comPath;
    }

    private static List<YangPathPredicate> valPathPredicates(List<String> predicates, YangConstructType pathType, GeneratedYangParser.PathStatementContext pathCtx, YangLeafRef yangLeafRef) {
        ArrayList<YangPathPredicate> result = new ArrayList<YangPathPredicate>();
        for (String p : predicates) {
            p = p.substring(1, p.length() - 1);
            result.add(ListenerUtil.valPathEqualityExp(p.trim(), pathType, pathCtx, yangLeafRef));
        }
        return result;
    }

    private static YangPathPredicate valPathEqualityExp(String predicate, YangConstructType pathType, GeneratedYangParser.PathStatementContext pathCtx, YangLeafRef yangLeafRef) {
        String[] exp = predicate.split(REGEX_EQUAL);
        YangNodeIdentifier nodeId = ListenerUtil.getValidNodeIdentifier(exp[0].trim(), pathType, pathCtx);
        YangRelativePath relPath = ListenerUtil.valPathKeyExp(exp[1].trim(), pathType, pathCtx, yangLeafRef);
        YangPathPredicate pathPredicate = new YangPathPredicate();
        pathPredicate.setNodeId(nodeId);
        pathPredicate.setPathOp(YangPathOperator.EQUALTO);
        pathPredicate.setRelPath(relPath);
        return pathPredicate;
    }

    private static YangRelativePath valPathKeyExp(String relPath, YangConstructType pathType, GeneratedYangParser.PathStatementContext pathCtx, YangLeafRef yangLeafRef) {
        String[] relative = relPath.split("/");
        int count = 0;
        ArrayList<String> atomicContent = new ArrayList<String>();
        for (String val : relative) {
            if (val.trim().equals("..")) {
                ++count;
                continue;
            }
            atomicContent.add(val);
        }
        YangRelativePath relativePath = new YangRelativePath();
        relativePath.setAncestorNodeCount(count);
        relativePath.setAtomicPathList(ListenerUtil.valRelPathKeyExp(atomicContent, pathType, pathCtx, yangLeafRef));
        return relativePath;
    }

    private static List<YangAtomicPath> valRelPathKeyExp(List<String> content, YangConstructType pathType, GeneratedYangParser.PathStatementContext pathCtx, YangLeafRef yangLeafRef) {
        String current = content.get(0);
        String[] curStr = current.trim().split(REGEX_OPEN_BRACE);
        if (!curStr[0].trim().equals("current") || !curStr[1].trim().equals(")")) {
            throw ListenerUtil.getPathException(pathCtx, yangLeafRef);
        }
        content.remove(0);
        ArrayList<YangAtomicPath> atomicList = new ArrayList<YangAtomicPath>();
        for (String relPath : content) {
            YangNodeIdentifier nodeId = ListenerUtil.getValidNodeIdentifier(relPath, pathType, pathCtx);
            YangAtomicPath atomicPath = new YangAtomicPath();
            atomicPath.setNodeIdentifier(nodeId);
            atomicList.add(atomicPath);
        }
        return atomicList;
    }

    public static String getPath(String path, List<YangAtomicPath> atomicList, YangConstructType pathType, GeneratedYangParser.PathStatementContext pathCtx) {
        String nodeId;
        String comPath = path;
        if (comPath.contains("/")) {
            nodeId = comPath.substring(0, comPath.indexOf(47));
            comPath = comPath.substring(comPath.indexOf(47));
        } else {
            nodeId = comPath;
            comPath = null;
        }
        YangNodeIdentifier validNodeId = ListenerUtil.getValidNodeIdentifier(nodeId, pathType, pathCtx);
        YangAtomicPath atomicPath = new YangAtomicPath();
        atomicPath.setNodeIdentifier(validNodeId);
        atomicList.add(atomicPath);
        return comPath;
    }

    private static ParserException getPathException(GeneratedYangParser.PathStatementContext pathCtx, YangLeafRef yangLeafRef) {
        ParserException exception = new ParserException("YANG file error : Path " + yangLeafRef.getPath() + " does not follow valid path syntax");
        exception.setLine(pathCtx.getStart().getLine());
        exception.setCharPosition(pathCtx.getStart().getCharPositionInLine());
        return exception;
    }

    public static String getPrefixRemovedName(List<YangAtomicPath> atomics, YangNode root) {
        String rootPrefix = ListenerUtil.getRootPrefix(root);
        StringBuilder builder = new StringBuilder();
        for (YangAtomicPath atomic : atomics) {
            String prefix = atomic.getNodeIdentifier().getPrefix();
            String name = atomic.getNodeIdentifier().getName();
            String id = rootPrefix.equals(prefix) || prefix == null ? "/" + name : "/" + prefix + ":" + name;
            builder.append(id);
        }
        return builder.toString();
    }
}

