/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.translator.tojava.utils;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.onosproject.yang.compiler.datamodel.InvalidOpTypeHolder;
import org.onosproject.yang.compiler.datamodel.YangAtomicPath;
import org.onosproject.yang.compiler.datamodel.YangAugment;
import org.onosproject.yang.compiler.datamodel.YangLeafRef;
import org.onosproject.yang.compiler.datamodel.YangNode;
import org.onosproject.yang.compiler.datamodel.YangNodeIdentifier;
import org.onosproject.yang.compiler.datamodel.YangType;
import org.onosproject.yang.compiler.datamodel.utils.builtindatatype.YangDataTypes;
import org.onosproject.yang.compiler.translator.exception.TranslatorException;
import org.onosproject.yang.compiler.translator.tojava.JavaCodeGeneratorInfo;
import org.onosproject.yang.compiler.translator.tojava.JavaFileInfoContainer;
import org.onosproject.yang.compiler.translator.tojava.JavaFileInfoTranslator;
import org.onosproject.yang.compiler.translator.tojava.JavaImportData;
import org.onosproject.yang.compiler.translator.tojava.JavaQualifiedTypeInfoTranslator;
import org.onosproject.yang.compiler.translator.tojava.TempJavaBeanFragmentFiles;
import org.onosproject.yang.compiler.translator.tojava.TempJavaCodeFragmentFiles;
import org.onosproject.yang.compiler.translator.tojava.TempJavaEnumerationFragmentFiles;
import org.onosproject.yang.compiler.translator.tojava.TempJavaEventFragmentFiles;
import org.onosproject.yang.compiler.translator.tojava.TempJavaFragmentFiles;
import org.onosproject.yang.compiler.translator.tojava.TempJavaServiceFragmentFiles;
import org.onosproject.yang.compiler.translator.tojava.TempJavaTypeFragmentFiles;
import org.onosproject.yang.compiler.translator.tojava.YangJavaModelUtils;
import org.onosproject.yang.compiler.translator.tojava.utils.ClassDefinitionGenerator;
import org.onosproject.yang.compiler.utils.UtilConstants;
import org.onosproject.yang.compiler.utils.io.YangPluginConfig;
import org.onosproject.yang.compiler.utils.io.impl.CopyrightHeader;
import org.onosproject.yang.compiler.utils.io.impl.JavaDocGen;
import org.onosproject.yang.compiler.utils.io.impl.YangIoUtils;

public final class JavaFileGeneratorUtils {
    private JavaFileGeneratorUtils() {
    }

    public static File getFileObject(String filePath, String fileName, String extension, JavaFileInfoTranslator handler) {
        return new File(handler.getBaseCodeGenPath() + filePath + UtilConstants.SLASH + fileName + extension);
    }

    static String getDataFromTempFileHandle(int tempFiles, TempJavaFragmentFiles tempHandle, String path) throws IOException {
        TempJavaTypeFragmentFiles typeHandle = null;
        if (tempHandle instanceof TempJavaTypeFragmentFiles) {
            typeHandle = (TempJavaTypeFragmentFiles)tempHandle;
        }
        TempJavaBeanFragmentFiles beanHandle = null;
        if (tempHandle instanceof TempJavaBeanFragmentFiles) {
            beanHandle = (TempJavaBeanFragmentFiles)tempHandle;
        }
        TempJavaServiceFragmentFiles serviceHandle = null;
        if (tempHandle instanceof TempJavaServiceFragmentFiles) {
            serviceHandle = (TempJavaServiceFragmentFiles)tempHandle;
        }
        TempJavaEventFragmentFiles eventHandle = null;
        if (tempHandle instanceof TempJavaEventFragmentFiles) {
            eventHandle = (TempJavaEventFragmentFiles)tempHandle;
        }
        if ((tempFiles & 1) != 0) {
            return tempHandle.getTemporaryDataFromFileHandle(tempHandle.getAttributesTempFileHandle(), path);
        }
        if ((tempFiles & 2) != 0) {
            return tempHandle.getTemporaryDataFromFileHandle(tempHandle.getGetterInterfaceTempFileHandle(), path);
        }
        if ((tempFiles & 8) != 0) {
            return tempHandle.getTemporaryDataFromFileHandle(tempHandle.getSetterInterfaceTempFileHandle(), path);
        }
        if ((tempFiles & 4) != 0) {
            return tempHandle.getTemporaryDataFromFileHandle(tempHandle.getGetterImplTempFileHandle(), path);
        }
        if ((tempFiles & 0x10) != 0) {
            return tempHandle.getTemporaryDataFromFileHandle(tempHandle.getSetterImplTempFileHandle(), path);
        }
        if ((tempFiles & 0x100000) != 0) {
            return tempHandle.getTemporaryDataFromFileHandle(tempHandle.getAddToListInterfaceTempFileHandle(), path);
        }
        if ((tempFiles & 0x200000) != 0) {
            return tempHandle.getTemporaryDataFromFileHandle(tempHandle.getAddToListImplTempFileHandle(), path);
        }
        if ((tempFiles & 0x4000000) != 0) {
            return tempHandle.getTemporaryDataFromFileHandle(tempHandle.getEditContentTempFileHandle(), path);
        }
        if ((tempFiles & 0x400000) != 0) {
            return tempHandle.getTemporaryDataFromFileHandle(tempHandle.getLeafIdAttributeTempFileHandle(), path);
        }
        if ((tempFiles & 0x20) != 0) {
            if (beanHandle == null) {
                throw new TranslatorException("Required constructor info is missing.");
            }
            return beanHandle.getTemporaryDataFromFileHandle(beanHandle.getConstructorImplTempFileHandle(), path);
        }
        if ((tempFiles & 0x40) != 0) {
            return tempHandle.getTemporaryDataFromFileHandle(tempHandle.getHashCodeImplTempFileHandle(), path);
        }
        if ((tempFiles & 0x80) != 0) {
            return tempHandle.getTemporaryDataFromFileHandle(tempHandle.getEqualsImplTempFileHandle(), path);
        }
        if ((tempFiles & 0x100) != 0) {
            return tempHandle.getTemporaryDataFromFileHandle(tempHandle.getToStringImplTempFileHandle(), path);
        }
        if ((tempFiles & 0x200) != 0) {
            if (typeHandle == null) {
                throw new TranslatorException("Required of string implementation info is missing.");
            }
            return typeHandle.getTemporaryDataFromFileHandle(typeHandle.getOfStringImplTempFileHandle(), path);
        }
        if ((tempFiles & 0x400) != 0) {
            if (typeHandle == null) {
                throw new TranslatorException("Required constructor implementation info is missing.");
            }
            return typeHandle.getTemporaryDataFromFileHandle(typeHandle.getConstructorForTypeTempFileHandle(), path);
        }
        if ((tempFiles & 0x800) != 0) {
            return tempHandle.getTemporaryDataFromFileHandle(tempHandle.getFromStringImplTempFileHandle(), path);
        }
        if ((tempFiles & 0x1000) != 0) {
            if (!(tempHandle instanceof TempJavaEnumerationFragmentFiles)) {
                throw new TranslatorException("Required enum info is missing.");
            }
            TempJavaEnumerationFragmentFiles enumHandle = (TempJavaEnumerationFragmentFiles)tempHandle;
            return enumHandle.getTemporaryDataFromFileHandle(enumHandle.getEnumClassTempFileHandle(), path);
        }
        if ((tempFiles & 0x2000) != 0) {
            if (serviceHandle == null) {
                throw new TranslatorException("Required rpc interface info is missing.");
            }
            return serviceHandle.getTemporaryDataFromFileHandle(serviceHandle.getRpcInterfaceTempFileHandle(), path);
        }
        if ((tempFiles & 0x8000) != 0) {
            if (eventHandle == null) {
                throw new TranslatorException("Required event enum implementation info is missing.");
            }
            return eventHandle.getTemporaryDataFromFileHandle(eventHandle.getEventEnumTempFileHandle(), path);
        }
        if ((tempFiles & 0x10000) != 0) {
            if (eventHandle == null) {
                throw new TranslatorException("Required event method implementation info is missing.");
            }
            return eventHandle.getTemporaryDataFromFileHandle(eventHandle.getEventMethodTempFileHandle(), path);
        }
        if ((tempFiles & 0x40000) != 0) {
            if (eventHandle == null) {
                throw new TranslatorException("Required event subject getter implementation info is missing.");
            }
            return eventHandle.getTemporaryDataFromFileHandle(eventHandle.getEventSubjectGetterTempFileHandle(), path);
        }
        if ((tempFiles & 0x80000) != 0) {
            if (eventHandle == null) {
                throw new TranslatorException("Required event subject setter implementation info is missing.");
            }
            return eventHandle.getTemporaryDataFromFileHandle(eventHandle.getEventSubjectSetterTempFileHandle(), path);
        }
        if ((tempFiles & 0x20000) != 0) {
            if (eventHandle == null) {
                throw new TranslatorException("Required event subject attribute implementation info is missing.");
            }
            return eventHandle.getTemporaryDataFromFileHandle(eventHandle.getEventSubjectAttributeTempFileHandle(), path);
        }
        return null;
    }

    public static void initiateJavaFileGeneration(File file, String className, int genType, List<String> imports, String pkg) throws IOException {
        if (file.exists()) {
            throw new IOException(" file " + file.getName() + " is already generated for " + className + " @ " + pkg + "\n" + "please check whether multiple yang files has same module/submodule \"name\" and \"namespace\" or You may have generated code of previous build present in your directory.");
        }
        try {
            boolean isFileCreated = file.createNewFile();
            if (!isFileCreated) {
                throw new IOException("Failed to create " + file.getName() + " class file.");
            }
            JavaFileGeneratorUtils.appendContents(file, className, genType, imports, pkg);
        }
        catch (IOException e) {
            throw new IOException("Failed to append contents in " + file.getName() + " class file.", e);
        }
    }

    public static void initiateJavaFileGeneration(File file, int genType, List<String> imports, YangNode curNode, String name) throws IOException {
        if (file.exists()) {
            throw new IOException(" file " + file.getName() + " is already generated for: " + name + "\n" + "please check whether multiple yang files has same module/submodule \"name\" and \"namespace\" or You may have generated code of previous build present in your directory.");
        }
        try {
            boolean isFileCreated = file.createNewFile();
            if (!isFileCreated) {
                throw new IOException("Failed to create " + file.getName() + " class file.");
            }
            JavaFileGeneratorUtils.appendContents(file, genType, imports, curNode, name);
        }
        catch (IOException e) {
            throw new IOException("Failed to append contents in " + file.getName() + " class file.", e);
        }
    }

    private static void appendContents(File file, int genType, List<String> importsList, YangNode curNode, String className) throws IOException {
        JavaFileInfoTranslator javaFileInfo = ((JavaFileInfoContainer)((Object)curNode)).getJavaFileInfo();
        String name = javaFileInfo.getJavaName();
        String path = javaFileInfo.getBaseCodeGenPath() + javaFileInfo.getPackageFilePath();
        String pkgString = genType == 256 || genType == 512 || genType == 1024 ? JavaFileGeneratorUtils.parsePackageString((path + "." + name).toLowerCase(), importsList) : JavaFileGeneratorUtils.parsePackageString(path, importsList);
        switch (genType) {
            case 1: {
                JavaFileGeneratorUtils.appendHeaderContents(file, pkgString, importsList);
                JavaFileGeneratorUtils.write(file, genType, JavaDocGen.JavaDocType.INTERFACE, curNode, className, false);
                break;
            }
            case 4096: {
                JavaFileGeneratorUtils.appendHeaderContents(file, pkgString, importsList);
                JavaFileGeneratorUtils.write(file, genType, JavaDocGen.JavaDocType.DEFAULT_CLASS, curNode, className, false);
                break;
            }
            case 8: {
                JavaFileGeneratorUtils.appendHeaderContents(file, pkgString, importsList);
                JavaFileGeneratorUtils.write(file, genType, JavaDocGen.JavaDocType.DEFAULT_CLASS, curNode, className, curNode.isOpTypeReq());
                break;
            }
            case 16: {
                JavaFileGeneratorUtils.appendHeaderContents(file, pkgString, importsList);
                JavaFileGeneratorUtils.write(file, genType, JavaDocGen.JavaDocType.RPC_INTERFACE, curNode, className, false);
                break;
            }
            case 256: {
                JavaFileGeneratorUtils.appendHeaderContents(file, pkgString, importsList);
                JavaFileGeneratorUtils.write(file, genType, JavaDocGen.JavaDocType.EVENT, curNode, className, false);
                break;
            }
            case 512: {
                JavaFileGeneratorUtils.appendHeaderContents(file, pkgString, importsList);
                JavaFileGeneratorUtils.write(file, genType, JavaDocGen.JavaDocType.EVENT_LISTENER, curNode, className, false);
                break;
            }
            case 1024: {
                JavaFileGeneratorUtils.appendHeaderContents(file, pkgString, importsList);
                JavaFileGeneratorUtils.write(file, genType, JavaDocGen.JavaDocType.EVENT_SUBJECT_CLASS, curNode, className, false);
                break;
            }
            case 2048: {
                JavaFileGeneratorUtils.appendHeaderContents(file, pkgString, importsList);
                JavaFileGeneratorUtils.write(file, genType, JavaDocGen.JavaDocType.EVENT_SUBJECT_CLASS, curNode, className, false);
                break;
            }
            case 8192: {
                JavaFileGeneratorUtils.appendHeaderContents(file, pkgString, importsList);
                JavaFileGeneratorUtils.write(file, genType, JavaDocGen.JavaDocType.RPC_HANDLER, curNode, className, false);
                break;
            }
            case 16384: {
                JavaFileGeneratorUtils.appendHeaderContents(file, pkgString, importsList);
                JavaFileGeneratorUtils.write(file, genType, JavaDocGen.JavaDocType.REGISTER_RPC, curNode, className, false);
                break;
            }
            case 32768: {
                JavaFileGeneratorUtils.appendHeaderContents(file, pkgString, importsList);
                JavaFileGeneratorUtils.write(file, genType, JavaDocGen.JavaDocType.RPC_COMMAND, curNode, className, false);
                break;
            }
            case 65536: {
                JavaFileGeneratorUtils.appendHeaderContents(file, pkgString, importsList);
                JavaFileGeneratorUtils.write(file, genType, JavaDocGen.JavaDocType.RPC_EXTENDED_CMD, curNode, className, false);
            }
        }
    }

    private static void appendContents(File file, String fileName, int genType, List<String> importsList, String pkg) throws IOException {
        String pkgString = JavaFileGeneratorUtils.parsePackageString(pkg, importsList);
        switch (genType) {
            case 64: {
                JavaFileGeneratorUtils.appendHeaderContents(file, pkgString, importsList);
                JavaFileGeneratorUtils.write(file, fileName, genType, JavaDocGen.JavaDocType.DEFAULT_CLASS);
                break;
            }
            case 128: {
                JavaFileGeneratorUtils.appendHeaderContents(file, pkgString, importsList);
                JavaFileGeneratorUtils.write(file, fileName, genType, JavaDocGen.JavaDocType.DEFAULT_CLASS);
                break;
            }
            case 32: {
                JavaFileGeneratorUtils.appendHeaderContents(file, pkgString, importsList);
                JavaFileGeneratorUtils.write(file, fileName, genType, JavaDocGen.JavaDocType.ENUM_CLASS);
                break;
            }
        }
    }

    private static String parsePackageString(String javaPkg, List<String> importsList) {
        javaPkg = YangIoUtils.parsePkg(YangIoUtils.getJavaPackageFromPackagePath(javaPkg));
        if (importsList != null) {
            if (!importsList.isEmpty()) {
                return "package " + javaPkg + ";" + "\n";
            }
            return "package " + javaPkg + ";";
        }
        return "package " + javaPkg + ";";
    }

    private static void appendHeaderContents(File file, String pkg, List<String> importsList) throws IOException {
        YangIoUtils.insertDataIntoJavaFile(file, CopyrightHeader.parseCopyrightHeader());
        YangIoUtils.insertDataIntoJavaFile(file, pkg);
        if (importsList != null) {
            YangIoUtils.insertDataIntoJavaFile(file, "\n");
            for (String imports : importsList) {
                YangIoUtils.insertDataIntoJavaFile(file, imports);
            }
        }
    }

    private static void write(File file, int genType, JavaDocGen.JavaDocType javaDocType, YangNode curNode, String fileName, boolean isForClass) throws IOException {
        YangIoUtils.insertDataIntoJavaFile(file, JavaDocGen.getJavaDoc(javaDocType, curNode.getJavaClassNameOrBuiltInType(), isForClass, null));
        YangIoUtils.insertDataIntoJavaFile(file, ClassDefinitionGenerator.generateClassDefinition(genType, fileName, curNode));
    }

    private static void write(File file, String fileName, int genType, JavaDocGen.JavaDocType javaDocType) throws IOException {
        YangIoUtils.insertDataIntoJavaFile(file, JavaDocGen.getJavaDoc(javaDocType, fileName, false, null));
        YangIoUtils.insertDataIntoJavaFile(file, ClassDefinitionGenerator.generateClassDefinition(genType, fileName));
    }

    static List<YangAtomicPath> getSetOfNodeIdentifiers(YangNode parent) {
        ArrayList<YangAtomicPath> targets = new ArrayList<YangAtomicPath>();
        List<YangAugment> augments = JavaFileGeneratorUtils.getListOfAugments(parent);
        for (YangAugment augment : augments) {
            YangNodeIdentifier nodeId = augment.getTargetNode().get(0).getNodeIdentifier();
            augment.setSetterMethodName(JavaFileGeneratorUtils.getAugmentSetterName(augment));
            if (!JavaFileGeneratorUtils.validateNodeIdentifierInSet(nodeId, targets)) continue;
            targets.add(augment.getTargetNode().get(0));
        }
        return targets;
    }

    private static List<YangAugment> getListOfAugments(YangNode parent) {
        ArrayList<YangAugment> augments = new ArrayList<YangAugment>();
        for (YangNode child = parent.getChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof YangAugment)) continue;
            augments.add((YangAugment)child);
        }
        return augments;
    }

    private static String getAugmentSetterName(YangAugment augment) {
        YangAtomicPath atomicPath = augment.getTargetNode().get(0);
        YangNode augmentedNode = atomicPath.getResolvedNode();
        String setterName = "setAugmented" + YangIoUtils.getCapitalCase(((JavaFileInfoContainer)((Object)augmentedNode.getParent())).getJavaFileInfo().getJavaName()) + YangIoUtils.getCapitalCase(((JavaFileInfoContainer)((Object)augmentedNode)).getJavaFileInfo().getJavaName());
        return setterName;
    }

    private static boolean validateNodeIdentifierInSet(YangNodeIdentifier nodeId, List<YangAtomicPath> targets) {
        boolean isPresent = true;
        for (YangAtomicPath target : targets) {
            if (!target.getNodeIdentifier().getName().equals(nodeId.getName())) continue;
            if (target.getNodeIdentifier().getPrefix() != null) {
                isPresent = !target.getNodeIdentifier().getPrefix().equals(nodeId.getPrefix());
                continue;
            }
            isPresent = nodeId.getPrefix() != null;
        }
        return isPresent;
    }

    public static void addResolvedAugmentedDataNodeImports(YangNode parent) {
        List<YangAtomicPath> targets = JavaFileGeneratorUtils.getSetOfNodeIdentifiers(parent);
        if (targets.isEmpty()) {
            return;
        }
        YangNode node = targets.get(0).getResolvedNode();
        if (node instanceof InvalidOpTypeHolder) {
            return;
        }
        TempJavaCodeFragmentFiles tempJavaCodeFragmentFiles = ((JavaCodeGeneratorInfo)((Object)parent)).getTempJavaCodeFragmentFiles();
        JavaFileInfoTranslator parentInfo = ((JavaFileInfoContainer)((Object)parent)).getJavaFileInfo();
        for (YangAtomicPath nodeId : targets) {
            YangNode augmentedNode = nodeId.getResolvedNode().getParent();
            String curNodeName = JavaFileGeneratorUtils.getCurNodeName(augmentedNode, parentInfo.getPluginConfig());
            JavaQualifiedTypeInfoTranslator typeInfo = JavaFileGeneratorUtils.getQTypeInfoOfNode(augmentedNode, curNodeName + "OpParam", parentInfo.getPluginConfig());
            tempJavaCodeFragmentFiles.getServiceTempFiles().getJavaImportData().addImportInfo(typeInfo, parentInfo.getJavaName(), parentInfo.getPackage());
            typeInfo = JavaFileGeneratorUtils.getQTypeInfoOfNode(augmentedNode, curNodeName, parentInfo.getPluginConfig());
            tempJavaCodeFragmentFiles.getServiceTempFiles().getJavaImportData().addImportInfo(typeInfo, parentInfo.getJavaName(), parentInfo.getPackage());
        }
    }

    private static JavaQualifiedTypeInfoTranslator getQTypeInfoOfNode(YangNode augmentedNode, String curNodeName, YangPluginConfig pluginConfig) {
        JavaQualifiedTypeInfoTranslator javaQualifiedTypeInfo = JavaQualifiedTypeInfoTranslator.getQualifiedTypeInfoOfCurNode(augmentedNode, curNodeName);
        if (javaQualifiedTypeInfo.getPkgInfo() == null) {
            javaQualifiedTypeInfo.setPkgInfo(YangJavaModelUtils.getNodesPackage(augmentedNode, pluginConfig));
        }
        return javaQualifiedTypeInfo;
    }

    private static boolean validateQualifiedInfoOfAugmentedNode(JavaQualifiedTypeInfoTranslator javaQualifiedTypeInfo, JavaImportData importData) {
        for (JavaQualifiedTypeInfoTranslator curImportInfo : importData.getImportSet()) {
            if (!curImportInfo.getClassInfo().contentEquals(javaQualifiedTypeInfo.getClassInfo())) continue;
            return curImportInfo.getPkgInfo().contentEquals(javaQualifiedTypeInfo.getPkgInfo());
        }
        return true;
    }

    static String getAugmentedClassNameForDataMethods(YangNode augmentedNode, YangNode parent) {
        JavaFileInfoTranslator parentInfo = ((JavaFileInfoContainer)((Object)parent)).getJavaFileInfo();
        YangPluginConfig pluginConfig = parentInfo.getPluginConfig();
        TempJavaServiceFragmentFiles tempJavaServiceFragmentFiles = ((JavaCodeGeneratorInfo)((Object)parent)).getTempJavaCodeFragmentFiles().getServiceTempFiles();
        String curNodeName = JavaFileGeneratorUtils.getCurNodeName(augmentedNode, pluginConfig);
        JavaQualifiedTypeInfoTranslator javaQualifiedTypeInfo = JavaFileGeneratorUtils.getQTypeInfoOfNode(augmentedNode, YangIoUtils.getCapitalCase(curNodeName), parentInfo.getPluginConfig());
        if (JavaFileGeneratorUtils.validateQualifiedInfoOfAugmentedNode(javaQualifiedTypeInfo, tempJavaServiceFragmentFiles.getJavaImportData())) {
            return javaQualifiedTypeInfo.getClassInfo();
        }
        return javaQualifiedTypeInfo.getPkgInfo() + "." + javaQualifiedTypeInfo.getClassInfo();
    }

    static String getCurNodeName(YangNode node, YangPluginConfig config) {
        if (((JavaFileInfoContainer)((Object)node)).getJavaFileInfo().getJavaName() != null) {
            return YangIoUtils.getCapitalCase(((JavaFileInfoContainer)((Object)node)).getJavaFileInfo().getJavaName());
        }
        return YangIoUtils.getCapitalCase(YangIoUtils.getCamelCase(node.getName(), config.getConflictResolver()));
    }

    public static String isTypeNameLeafref(String attributeName, YangType<?> attributeType) {
        YangLeafRef leafRef;
        if (attributeName.equalsIgnoreCase("leafref") && (leafRef = (YangLeafRef)attributeType.getDataTypeExtendedInfo()) != null && !leafRef.isInGrouping()) {
            return attributeType.getDataTypeName();
        }
        return attributeName;
    }

    public static YangType isTypeLeafref(YangType<?> attributeType) {
        YangLeafRef leafRef;
        if (attributeType.getDataType() == YangDataTypes.LEAFREF && !(leafRef = (YangLeafRef)attributeType.getDataTypeExtendedInfo()).isInGrouping()) {
            return leafRef.getEffectiveDataType();
        }
        return attributeType;
    }
}

