/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.augmentchoice.rev20160826.augmentchoice;

/**
 * Represents the implementation of privateIp.
 */
public abstract class PrivateIp extends Ip {

    /**
     * Returns the attribute private-ip.
     *
     * @return private-ip value of private-ip
     */
    public static String privateIpToString() {
        return "private-ip";
    }

    /**
     * Returns the object of privateIp fromString input String privateIp.
     *
     * @param valInString value of input String
     * @return privateIp
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("private-ip")) {
            return PrivateIp.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}