/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.augmentchoice.rev20160826.augmentchoice.contenttest.valid;

import java.util.BitSet;
import java.util.List;
import org.onosproject.yang.gen.v1.augmentchoice.rev20160826.augmentchoice.Ip;
import org.onosproject.yang.gen.v1.augmentchoice.rev20160826.augmentchoice.contenttest.valid.augmentedschvalid.AugCaseModKey;
import org.onosproject.yang.gen.v1.augmentchoice.rev20160826.augmentchoice.contenttest.valid.augmentedschvalid.TestedCont;
import org.onosproject.yang.gen.v1.augmentchoice.rev20160826.augmentchoice.contenttest.valid.augmentedschvalid.UnlistedVal;

/**
 * Abstraction of an entity which represents the functionality of augmentedSchValid.
 */
public interface AugmentedSchValid {

    /**
     * Identify the leaf of AugmentedSchValid.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents chTest.
         */
        CHTEST(1),
        /**
         * Represents test.
         */
        TEST(2);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute chTest.
     *
     * @return chTest value of chTest
     */
    Class<? extends Ip> chTest();

    /**
     * Returns the attribute test.
     *
     * @return test list of test
     */
    List<Byte> test();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute testedCont.
     *
     * @return testedCont value of testedCont
     */
    TestedCont testedCont();

    /**
     * Returns the attribute unlistedVal.
     *
     * @return unlistedVal list of unlistedVal
     */
    List<UnlistedVal> unlistedVal();

    /**
     * Returns the attribute augCaseModKey.
     *
     * @return augCaseModKey list of augCaseModKey
     */
    List<AugCaseModKey> augCaseModKey();

    /**
     * Sets the attribute chTest.
     *
     * @param chTest value of chTest
     */
    void chTest(Class<? extends Ip> chTest);

    /**
     * Sets the attribute test.
     *
     * @param test list of test
     */
    void test(List<Byte> test);

    /**
     * Sets the attribute testedCont.
     *
     * @param testedCont value of testedCont
     */
    void testedCont(TestedCont testedCont);

    /**
     * Sets the attribute unlistedVal.
     *
     * @param unlistedVal list of unlistedVal
     */
    void unlistedVal(List<UnlistedVal> unlistedVal);

    /**
     * Sets the attribute augCaseModKey.
     *
     * @param augCaseModKey list of augCaseModKey
     */
    void augCaseModKey(List<AugCaseModKey> augCaseModKey);

    /**
     * Adds to the list of test.
     *
     * @param addTo value of test
     */
    void addToTest(Byte addTo);

    /**
     * Adds to the list of unlistedVal.
     *
     * @param addTo value of unlistedVal
     */
    void addToUnlistedVal(UnlistedVal addTo);

    /**
     * Adds to the list of augCaseModKey.
     *
     * @param addTo value of augCaseModKey
     */
    void addToAugCaseModKey(AugCaseModKey addTo);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}