/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.check.check.list56.cont56;

import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.check.check.list56.cont56.augmentedcont56.Cont57;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of augmentedCont56.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultAugmentedCont56 extends InnerModelObject implements AugmentedCont56 {
    protected Cont57 cont57;

    @Override
    public Cont57 cont57() {
        return cont57;
    }

    @Override
    public void cont57(Cont57 cont57) {
        this.cont57 = cont57;
    }

    @Override
    public int hashCode() {
        return Objects.hash(cont57);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultAugmentedCont56) {
            DefaultAugmentedCont56 other = (DefaultAugmentedCont56) obj;
            return
                Objects.equals(cont57, other.cont57);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("cont57=" + cont57)
            .toString();
    }


    /**
     * Creates an instance of defaultAugmentedCont56.
     */
    public DefaultAugmentedCont56() {
    }

}