/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.hello.rev20150105;

import org.onosproject.yang.gen.v1.hello.rev20150105.hello.hellosecond.HelloSecondInput;
import org.onosproject.yang.gen.v1.hello.rev20150105.hello.hellosecond.HelloSecondOutput;
import org.onosproject.yang.gen.v1.hello.rev20150105.hello.helloworld.HelloWorldInput;
import org.onosproject.yang.gen.v1.hello.rev20150105.hello.helloworld.HelloWorldOutput;
import org.onosproject.yang.model.RpcInput;
import org.onosproject.yang.model.RpcOutput;
import org.onosproject.yang.model.RpcService;

/**
 * Abstraction of an entity which represents the functionality of hello.
 */
public interface HelloService extends RpcService {
    /**
     * Service interface of helloWorld.
     *
     * @param inputVar input of service interface helloWorld
     * @return rpcOutput output of service interface helloWorld
     */
    RpcOutput helloWorld(RpcInput inputVar);

    /**
     * Service interface of helloSecond.
     *
     * @param inputVar input of service interface helloSecond
     * @return rpcOutput output of service interface helloSecond
     */
    RpcOutput helloSecond(RpcInput inputVar);

}
