/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc;

/**
 * Represents the implementation of addressFamily.
 */
public abstract class AddressFamily {

    /**
     * Returns the attribute address-family.
     *
     * @return address-family value of address-family
     */
    public static String addressFamilyToString() {
        return "address-family";
    }

    /**
     * Returns the object of addressFamily fromString input String addressFamily.
     *
     * @param valInString value of input String
     * @return addressFamily
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("address-family")) {
            return AddressFamily.class;
        } else if (valInString.equals("ipv4")) {
            return Ipv4.class;
        } else if (valInString.equals("ipv6")) {
            return Ipv6.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}