/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc;

/**
 * Represents the implementation of customerApplication.
 */
public abstract class CustomerApplication {

    /**
     * Returns the attribute customer-application.
     *
     * @return customer-application value of customer-application
     */
    public static String customerApplicationToString() {
        return "customer-application";
    }

    /**
     * Returns the object of customerApplication fromString input String customerApplication.
     *
     * @param valInString value of input String
     * @return customerApplication
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("customer-application")) {
            return CustomerApplication.class;
        } else if (valInString.equals("web")) {
            return Web.class;
        } else if (valInString.equals("mail")) {
            return Mail.class;
        } else if (valInString.equals("file-transfer")) {
            return FileTransfer.class;
        } else if (valInString.equals("database")) {
            return Database.class;
        } else if (valInString.equals("social")) {
            return Social.class;
        } else if (valInString.equals("games")) {
            return Games.class;
        } else if (valInString.equals("p2p")) {
            return P2p.class;
        } else if (valInString.equals("network-management")) {
            return NetworkManagement.class;
        } else if (valInString.equals("voice")) {
            return Voice.class;
        } else if (valInString.equals("video")) {
            return Video.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}