/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc;

/**
 * Represents the implementation of tcJitter.
 */
public abstract class TcJitter extends TransportConstraint {

    /**
     * Returns the attribute tc-jitter.
     *
     * @return tc-jitter value of tc-jitter
     */
    public static String tcJitterToString() {
        return "tc-jitter";
    }

    /**
     * Returns the object of tcJitter fromString input String tcJitter.
     *
     * @param valInString value of input String
     * @return tcJitter
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("tc-jitter")) {
            return TcJitter.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}