/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.accessdiversity.accessdiversity.constraints;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.PlacementDiversity;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.accessdiversity.accessdiversity.constraints.constraint.Target;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of constraint.
 */
public interface Constraint extends Augmentable  {

    /**
     * Identify the leaf of Constraint.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents constraintType.
         */
        CONSTRAINTTYPE(1);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute constraintType.
     *
     * @return constraintType value of constraintType
     */
    Class<? extends PlacementDiversity> constraintType();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute target.
     *
     * @return target value of target
     */
    Target target();

    /**
     * Sets the attribute constraintType.
     *
     * @param constraintType value of constraintType
     */
    void constraintType(Class<? extends PlacementDiversity> constraintType);

    /**
     * Sets the attribute target.
     *
     * @param target value of target
     */
    void target(Target target);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}