/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.l3vpnsvc.vpnservices;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.SvcId;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.VpnTopology;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.transportconstraints.TransportConstraints;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.vpnextranet.ExtranetVpns;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.vpnservicecloudaccess.CloudAccesses;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.vpnservicemulticast.Multicast;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of vpnSvc.
 */
public interface VpnSvc extends Augmentable  {

    /**
     * Identify the leaf of VpnSvc.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents vpnId.
         */
        VPNID(1),
        /**
         * Represents customerName.
         */
        CUSTOMERNAME(2),
        /**
         * Represents topology.
         */
        TOPOLOGY(3),
        /**
         * Represents carrierscarrier.
         */
        CARRIERSCARRIER(4);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute vpnId.
     *
     * @return vpnId value of vpnId
     */
    SvcId vpnId();

    /**
     * Returns the attribute customerName.
     *
     * @return customerName value of customerName
     */
    String customerName();

    /**
     * Returns the attribute topology.
     *
     * @return topology value of topology
     */
    Class<? extends VpnTopology> topology();

    /**
     * Returns the attribute carrierscarrier.
     *
     * @return carrierscarrier value of carrierscarrier
     */
    boolean carrierscarrier();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute cloudAccesses.
     *
     * @return cloudAccesses value of cloudAccesses
     */
    CloudAccesses cloudAccesses();

    /**
     * Returns the attribute multicast.
     *
     * @return multicast value of multicast
     */
    Multicast multicast();

    /**
     * Returns the attribute transportConstraints.
     *
     * @return transportConstraints value of transportConstraints
     */
    TransportConstraints transportConstraints();

    /**
     * Returns the attribute extranetVpns.
     *
     * @return extranetVpns value of extranetVpns
     */
    ExtranetVpns extranetVpns();

    /**
     * Sets the attribute vpnId.
     *
     * @param vpnId value of vpnId
     */
    void vpnId(SvcId vpnId);

    /**
     * Sets the attribute customerName.
     *
     * @param customerName value of customerName
     */
    void customerName(String customerName);

    /**
     * Sets the attribute topology.
     *
     * @param topology value of topology
     */
    void topology(Class<? extends VpnTopology> topology);

    /**
     * Sets the attribute carrierscarrier.
     *
     * @param carrierscarrier value of carrierscarrier
     */
    void carrierscarrier(boolean carrierscarrier);

    /**
     * Sets the attribute cloudAccesses.
     *
     * @param cloudAccesses value of cloudAccesses
     */
    void cloudAccesses(CloudAccesses cloudAccesses);

    /**
     * Sets the attribute multicast.
     *
     * @param multicast value of multicast
     */
    void multicast(Multicast multicast);

    /**
     * Sets the attribute transportConstraints.
     *
     * @param transportConstraints value of transportConstraints
     */
    void transportConstraints(TransportConstraints transportConstraints);

    /**
     * Sets the attribute extranetVpns.
     *
     * @param extranetVpns value of extranetVpns
     */
    void extranetVpns(ExtranetVpns extranetVpns);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}