/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.sitesecurity;

import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.sitesecurityauthentication.Authentication;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.sitesecurityencryption.Encryption;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of security.
 */
public interface Security extends Augmentable  {

    /**
     * Returns the attribute authentication.
     *
     * @return authentication value of authentication
     */
    Authentication authentication();

    /**
     * Returns the attribute encryption.
     *
     * @return encryption value of encryption
     */
    Encryption encryption();

    /**
     * Sets the attribute authentication.
     *
     * @param authentication value of authentication
     */
    void authentication(Authentication authentication);

    /**
     * Sets the attribute encryption.
     *
     * @param encryption value of encryption
     */
    void encryption(Encryption encryption);

}