/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.sitesecurityencryption.encryption;

import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.sitesecurityencryption.encryption.encryptionprofile.Profile;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of encryptionProfile.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultEncryptionProfile extends InnerModelObject implements EncryptionProfile {
    protected Profile profile;

    @Override
    public Profile profile() {
        return profile;
    }

    @Override
    public void profile(Profile profile) {
        this.profile = profile;
    }

    @Override
    public int hashCode() {
        return Objects.hash(profile);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultEncryptionProfile) {
            DefaultEncryptionProfile other = (DefaultEncryptionProfile) obj;
            return
                Objects.equals(profile, other.profile);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("profile=" + profile)
            .toString();
    }


    /**
     * Creates an instance of defaultEncryptionProfile.
     */
    public DefaultEncryptionProfile() {
    }

}