/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.siteserviceqosprofile;

import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.siteserviceqosprofile.qos.QosClassificationPolicy;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.siteserviceqosprofile.qos.QosProfile;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of qos.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultQos extends InnerModelObject implements Qos {
    protected QosClassificationPolicy qosClassificationPolicy;
    protected QosProfile qosProfile;

    @Override
    public QosClassificationPolicy qosClassificationPolicy() {
        return qosClassificationPolicy;
    }

    @Override
    public QosProfile qosProfile() {
        return qosProfile;
    }

    @Override
    public void qosClassificationPolicy(QosClassificationPolicy qosClassificationPolicy) {
        this.qosClassificationPolicy = qosClassificationPolicy;
    }

    @Override
    public void qosProfile(QosProfile qosProfile) {
        this.qosProfile = qosProfile;
    }

    @Override
    public int hashCode() {
        return Objects.hash(qosClassificationPolicy, qosProfile);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultQos) {
            DefaultQos other = (DefaultQos) obj;
            return
                Objects.equals(qosClassificationPolicy, other.qosClassificationPolicy) &&
                Objects.equals(qosProfile, other.qosProfile);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("qosClassificationPolicy=" + qosClassificationPolicy)
            .add("qosProfile=" + qosProfile)
            .toString();
    }


    /**
     * Creates an instance of defaultQos.
     */
    public DefaultQos() {
    }

}