/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.siteserviceqosprofile.qos.qosclassificationpolicy;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.siteserviceqosprofile.qos.qosclassificationpolicy.rule.MatchType;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of rule.
 */
public interface Rule extends Augmentable  {

    /**
     * Identify the leaf of Rule.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents id.
         */
        ID(1),
        /**
         * Represents targetClassId.
         */
        TARGETCLASSID(2);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute id.
     *
     * @return id value of id
     */
    int id();

    /**
     * Returns the attribute targetClassId.
     *
     * @return targetClassId value of targetClassId
     */
    String targetClassId();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute matchType.
     *
     * @return matchType value of matchType
     */
    MatchType matchType();

    /**
     * Sets the attribute id.
     *
     * @param id value of id
     */
    void id(int id);

    /**
     * Sets the attribute targetClassId.
     *
     * @param targetClassId value of targetClassId
     */
    void targetClassId(String targetClassId);

    /**
     * Sets the attribute matchType.
     *
     * @param matchType value of matchType
     */
    void matchType(MatchType matchType);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}